/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.model.CPCloudSession;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBASession;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.DBAAuthCredentialsProvider;
import org.jkiss.dbeaver.model.auth.DBAAuthSpace;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import software.amazon.awssdk.auth.credentials.AwsCredentials;

public class AWSCloudSession
implements CPCloudSession<AWSCloudZone>,
DBAAuthCredentialsProvider {
    private final DBASession parentSession;
    private final AWSCloud cloud;
    private final String arn;
    private final AwsCredentials awsCredentials;
    private AWSCloudZone[] useZones;

    public AWSCloudSession(DBASession parentSession, AWSCloud cloud, String arn, AwsCredentials awsCredentials, AWSCloudZone[] useZones) {
        this.parentSession = parentSession;
        this.cloud = cloud;
        this.arn = arn;
        this.awsCredentials = awsCredentials;
        this.useZones = useZones;
    }

    @NotNull
    public DBAAuthSpace getSessionSpace() {
        return this.cloud;
    }

    @NotNull
    public String getSessionId() {
        return this.parentSession.getSessionId();
    }

    public boolean isApplicationSession() {
        return this.parentSession.isApplicationSession();
    }

    @Nullable
    public DBPProject getSingletonProject() {
        return this.parentSession.getSingletonProject();
    }

    @NotNull
    public AWSCloud getCloud() {
        return this.cloud;
    }

    @NotNull
    public AWSCloudZone[] getDefaultZones() {
        return this.useZones;
    }

    public void setDefaultZones(@NotNull AWSCloudZone[] zones) {
        this.useZones = zones;
    }

    public String[] getDefaultZoneIds() {
        return (String[])Arrays.stream(this.useZones).map(AWSCloudZone::getZoneId).toArray(String[]::new);
    }

    public String getArn() {
        return this.arn;
    }

    public String getAccountId() {
        return this.arn;
    }

    public AwsCredentials getCredentials() {
        return this.awsCredentials;
    }

    public void close() {
    }

    public boolean provideAuthParameters(DBPDataSourceContainer dataSourceContainer, DBPConnectionConfiguration configuration) {
        configuration.setAuthProperty("iam.aws_access_key", this.awsCredentials.accessKeyId());
        configuration.setAuthProperty("iam.aws_secret_key", this.awsCredentials.secretAccessKey());
        return true;
    }
}

