/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;

public enum AWSCloudService {
    RDS_POSTGRESQL("rds", "postgresql", "postgres-jdbc", "rds"),
    RDS_MYSQL("rds", "mysql", "mysql8", "rds"),
    RDS_MARIADB("rds", "mysql", "mariaDB", "rds"),
    RDS_ORACLE("rds", "oracle", "oracle_thin", "rds"),
    RDS_SQLSERVER("rds", "sqlserver", "microsoft", "rds"),
    REDSHIFT("redshift", "postgresql", "postgres-redshift-jdbc", "redshiftv2"),
    ATHENA("athena", "athena", "aws_athena_jdbc_simba", "athena"),
    DYNAMODB("dynamodb", "dynamodb", "dynamodb", "dynamodb"),
    DOCUMENTDB("documentdb", "aws-documentdb", "documentdb", "docdb"),
    KEYSPACES("keyspaces", "aws_keyspaces", "keyspaces", "keyspaces"),
    UNKNOWN("", "", "", "unknown");

    private final String serviceId;
    private final String providerId;
    private final String driverId;
    private final String prefix;

    private AWSCloudService(String serviceId, String providerId, String driverId, String prefix) {
        this.serviceId = serviceId;
        this.providerId = providerId;
        this.driverId = driverId;
        this.prefix = prefix;
    }

    @NotNull
    public String getServiceId() {
        return this.serviceId;
    }

    @NotNull
    public String getProviderId() {
        return this.providerId;
    }

    @NotNull
    public String getDriverId() {
        return this.driverId;
    }

    @NotNull
    public String getPrefix() {
        return this.prefix;
    }

    public DBPDriver getInstanceDriver() throws DBException {
        DataSourceProviderDescriptor dsProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(this.providerId);
        if (dsProvider == null) {
            throw new DBException("Datasource provider '" + this.providerId + "' not found");
        }
        DriverDescriptor driver = dsProvider.getDriver(this.driverId);
        if (driver == null) {
            throw new DBException("Driver '" + this.driverId + "' not found");
        }
        return driver;
    }

    @Nullable
    public static AWSCloudService getServiceByDriver(DBPDriver driver) {
        AWSCloudService[] aWSCloudServiceArray = AWSCloudService.values();
        int n = aWSCloudServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            AWSCloudService service = aWSCloudServiceArray[n2];
            if (service.providerId.equals(driver.getProviderId()) && service.driverId.equals(driver.getId())) {
                return service;
            }
            ++n2;
        }
        return null;
    }
}

