/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.aws.AWSDatabaseEngine;
import com.dbeaver.cloud.aws.athena.AWSCloudAthenaEndpoint;
import com.dbeaver.cloud.aws.documentdb.AWSCloudDocumentDBCluster;
import com.dbeaver.cloud.aws.dynamodb.AWSCloudDynamoDBEndpoint;
import com.dbeaver.cloud.aws.keyspaces.AWSCloudKeyspacesEndpoint;
import com.dbeaver.cloud.aws.rds.AWSCloudRdsInstance;
import com.dbeaver.cloud.aws.redshift.AWSCloudRedshiftCluster;
import com.dbeaver.cloud.model.CPCloudExplorer;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.model.services.CPDatabaseCategory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.services.docdb.DocDbClient;
import software.amazon.awssdk.services.docdb.model.DBCluster;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.docdb.model.DescribeDbClustersResponse;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.dynamodb.model.Endpoint;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DBInstance;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbInstancesResponse;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;

public class AWSCloudExplorer
implements CPCloudExplorer<AWSCloudZone> {
    private static final Log log = Log.getLog(AWSCloudExplorer.class);
    private final AWSCloud cloud;
    private AWSCloudSession session;
    private GetCallerIdentityResponse callerIdentity;

    public AWSCloudExplorer(AWSCloud cloud, AWSCloudSession session) {
        this.cloud = cloud;
        this.session = session;
    }

    @NotNull
    public AWSCloud getCloud() {
        return this.cloud;
    }

    @NotNull
    public CPDatabaseCategory[] getRootCategories(@NotNull DBRProgressMonitor monitor, @NotNull String serviceID) throws DBException {
        return new CPDatabaseCategory[0];
    }

    @NotNull
    public AWSCloudAbstractInstance[] findServiceInstances(@NotNull DBRProgressMonitor monitor, @NotNull String serviceID, @Nullable CPDatabaseCategory category) throws DBException {
        log.debug((Object)("[" + this.session.getSessionId() + "] Explore AWS zones: " + Arrays.toString(this.session.getDefaultZones())));
        try {
            monitor.subTask("Read STS user ID");
            this.callerIdentity = this.cloud.readGetCallerIdentity(monitor, this.session);
            monitor.worked(1);
            ArrayList<AWSCloudAthenaEndpoint> instances = new ArrayList<AWSCloudAthenaEndpoint>();
            AWSCloudZone[] aWSCloudZoneArray = this.session.getDefaultZones();
            int n = aWSCloudZoneArray.length;
            int n2 = 0;
            while (n2 < n) {
                AWSCloudZone zone = aWSCloudZoneArray[n2];
                try {
                    List<AWSCloudAbstractInstance> regionInstances = null;
                    switch (serviceID) {
                        case "rds": {
                            regionInstances = this.findRdsInstances(monitor, this.session, zone);
                            break;
                        }
                        case "redshift": {
                            regionInstances = this.findRedshiftInstances(monitor, this.session, zone);
                            break;
                        }
                        case "documentdb": {
                            regionInstances = this.findDocumentDBInstances(monitor, this.session, zone);
                            break;
                        }
                        case "keyspaces": {
                            regionInstances = this.findKeyspacesInstances(monitor, this.session, zone);
                            break;
                        }
                        case "dynamodb": {
                            regionInstances = this.findDynamoDBInstances(monitor, this.session, zone);
                            break;
                        }
                        case "athena": {
                            regionInstances = this.findAthenaInstances(monitor, this.session, zone);
                            break;
                        }
                        default: {
                            throw new DBException("Service '" + serviceID + "' not supported yet");
                        }
                    }
                    if (regionInstances != null) {
                        instances.addAll(regionInstances);
                    }
                }
                catch (Exception e) {
                    throw new DBException("Error loading " + serviceID + " instances in " + zone.getZoneId(), (Throwable)e);
                }
                ++n2;
            }
            return instances.toArray(new AWSCloudAbstractInstance[0]);
        }
        catch (Exception e) {
            throw new DBException("Error reading AWS instances", (Throwable)e);
        }
    }

    public AWSCloudAbstractInstance getServiceInstance(@NotNull DBRProgressMonitor monitor, @NotNull String serviceID, @NotNull AWSCloudZone zone, @NotNull String instanceId) throws DBException {
        monitor.subTask("Read STS user ID");
        this.callerIdentity = this.cloud.readGetCallerIdentity(monitor, this.session);
        monitor.worked(1);
        switch (serviceID) {
            case "rds": {
                return this.findRdsInstance(monitor, this.session, zone, instanceId);
            }
            case "redshift": {
                return this.findRedshiftInstance(monitor, this.session, zone, instanceId);
            }
            case "documentdb": {
                return this.findDocumentDBInstance(monitor, this.session, zone, instanceId);
            }
            case "keyspaces": {
                return this.findKeyspacesInstance(monitor, this.session, zone);
            }
            case "dynamodb": {
                return this.findDynamoDBInstance(monitor, this.session, zone);
            }
            case "athena": {
                return this.findAthenaInstance(monitor, this.session, zone);
            }
        }
        throw new DBException("Service '" + serviceID + "' not supported yet");
    }

    public void refreshSession(CPCloudSession cloudSession) {
        this.session = (AWSCloudSession)cloudSession;
    }

    private List<AWSCloudRdsInstance> findRdsInstances(DBRProgressMonitor monitor, AWSCloudSession session, AWSCloudZone zone) {
        monitor.subTask("Describe RDS instances");
        Set supportedEngineIds = Arrays.stream(AWSCloudRdsInstance.SUPPORTED_RDS_ENGINES).map(AWSDatabaseEngine::getEngineId).collect(Collectors.toSet());
        RdsClient rdsClient = (RdsClient)this.configureClient(RdsClient.builder(), session, zone).build();
        DescribeDbInstancesResponse instancesResponse = rdsClient.describeDBInstances();
        ArrayList<AWSCloudRdsInstance> instances = new ArrayList<AWSCloudRdsInstance>();
        for (DBInstance dbInstance : instancesResponse.dbInstances()) {
            if (supportedEngineIds.contains(dbInstance.engine())) {
                instances.add(new AWSCloudRdsInstance(session, zone, dbInstance));
                continue;
            }
            log.debug((Object)("Unsupported RDS engine: " + dbInstance.engine()));
        }
        return instances;
    }

    private AWSCloudRdsInstance findRdsInstance(DBRProgressMonitor monitor, AWSCloudSession session, AWSCloudZone zone, String instanceId) {
        monitor.subTask("Find RDS instance");
        RdsClient rdsClient = (RdsClient)this.configureClient(RdsClient.builder(), session, zone).build();
        DescribeDbInstancesResponse instancesResponse = rdsClient.describeDBInstances((DescribeDbInstancesRequest)DescribeDbInstancesRequest.builder().dbInstanceIdentifier(instanceId).build());
        return instancesResponse.dbInstances().stream().findFirst().map(i -> new AWSCloudRdsInstance(session, zone, (DBInstance)i)).orElse(null);
    }

    private List<AWSCloudRedshiftCluster> findRedshiftInstances(DBRProgressMonitor monitor, AWSCloudSession session, AWSCloudZone zone) {
        monitor.subTask("Describe Redshift clusters");
        RedshiftClient rdsClient = (RedshiftClient)this.configureClient(RedshiftClient.builder(), session, zone).build();
        DescribeClustersResponse clusters = rdsClient.describeClusters();
        ArrayList<AWSCloudRedshiftCluster> instances = new ArrayList<AWSCloudRedshiftCluster>();
        for (Cluster dbInstance : clusters.clusters()) {
            instances.add(new AWSCloudRedshiftCluster(session, zone, dbInstance));
        }
        return instances;
    }

    private AWSCloudRedshiftCluster findRedshiftInstance(DBRProgressMonitor monitor, AWSCloudSession session, AWSCloudZone zone, String clusterId) {
        monitor.subTask("Find Redshift cluster");
        RedshiftClient rdsClient = (RedshiftClient)this.configureClient(RedshiftClient.builder(), session, zone).build();
        DescribeClustersResponse clusters = rdsClient.describeClusters((DescribeClustersRequest)DescribeClustersRequest.builder().clusterIdentifier(clusterId).build());
        return clusters.clusters().stream().findFirst().map(c -> new AWSCloudRedshiftCluster(session, zone, (Cluster)c)).orElse(null);
    }

    private List<AWSCloudDocumentDBCluster> findDocumentDBInstances(DBRProgressMonitor monitor, AWSCloudSession session, AWSCloudZone zone) {
        monitor.subTask("Describe DocumentDB clusters");
        DocDbClient docdbClient = (DocDbClient)this.configureClient(DocDbClient.builder(), session, zone).build();
        DescribeDbClustersRequest clusterRequest = (DescribeDbClustersRequest)DescribeDbClustersRequest.builder().build();
        DescribeDbClustersResponse clustersResponse = docdbClient.describeDBClusters(clusterRequest);
        ArrayList<AWSCloudDocumentDBCluster> clusters = new ArrayList<AWSCloudDocumentDBCluster>();
        for (DBCluster dbInstance : clustersResponse.dbClusters()) {
            if (dbInstance.engine() != null && !dbInstance.engine().equals(AWSDatabaseEngine.DOCDB.getEngineId())) {
                log.debug((Object)("Unsupported DocDB engine: " + dbInstance.engine()));
                continue;
            }
            clusters.add(new AWSCloudDocumentDBCluster(session, zone, dbInstance));
        }
        return clusters;
    }

    private AWSCloudDocumentDBCluster findDocumentDBInstance(DBRProgressMonitor monitor, AWSCloudSession session, AWSCloudZone zone, String clusterId) {
        monitor.subTask("Find DocumentDB cluster");
        DocDbClient docdbClient = (DocDbClient)this.configureClient(DocDbClient.builder(), session, zone).build();
        DescribeDbClustersResponse clustersResponse = docdbClient.describeDBClusters((DescribeDbClustersRequest)DescribeDbClustersRequest.builder().dbClusterIdentifier(clusterId).build());
        return clustersResponse.dbClusters().stream().findFirst().map(c -> new AWSCloudDocumentDBCluster(session, zone, (DBCluster)c)).orElse(null);
    }

    private List<AWSCloudDynamoDBEndpoint> findDynamoDBInstances(DBRProgressMonitor monitor, AWSCloudSession session, AWSCloudZone zone) {
        monitor.subTask("Describe DynamoDB clusters");
        DynamoDbClient dynamoClient = (DynamoDbClient)this.configureClient(DynamoDbClient.builder(), session, zone).build();
        DescribeEndpointsResponse endpoints = dynamoClient.describeEndpoints();
        ArrayList<AWSCloudDynamoDBEndpoint> dynamoEnpoints = new ArrayList<AWSCloudDynamoDBEndpoint>();
        for (Endpoint dbInstance : endpoints.endpoints()) {
            dynamoEnpoints.add(new AWSCloudDynamoDBEndpoint(session, zone, dbInstance));
        }
        return dynamoEnpoints;
    }

    private AWSCloudDynamoDBEndpoint findDynamoDBInstance(DBRProgressMonitor monitor, AWSCloudSession session, AWSCloudZone zone) {
        monitor.subTask("Describe DynamoDB clusters");
        DynamoDbClient dynamoClient = (DynamoDbClient)this.configureClient(DynamoDbClient.builder(), session, zone).build();
        DescribeEndpointsResponse endpoints = dynamoClient.describeEndpoints();
        return endpoints.endpoints().stream().findFirst().map(c -> new AWSCloudDynamoDBEndpoint(session, zone, (Endpoint)c)).orElse(null);
    }

    private List<AWSCloudAthenaEndpoint> findAthenaInstances(DBRProgressMonitor monitor, AWSCloudSession session, AWSCloudZone zone) {
        return Collections.singletonList(this.findAthenaInstance(monitor, session, zone));
    }

    private AWSCloudAthenaEndpoint findAthenaInstance(DBRProgressMonitor monitor, AWSCloudSession session, AWSCloudZone zone) {
        return new AWSCloudAthenaEndpoint(session, zone, this.callerIdentity.account());
    }

    private List<AWSCloudKeyspacesEndpoint> findKeyspacesInstances(DBRProgressMonitor monitor, AWSCloudSession session, AWSCloudZone zone) {
        return Collections.singletonList(this.findKeyspacesInstance(monitor, session, zone));
    }

    private AWSCloudKeyspacesEndpoint findKeyspacesInstance(DBRProgressMonitor monitor, AWSCloudSession session, AWSCloudZone zone) {
        return new AWSCloudKeyspacesEndpoint(session, zone);
    }

    private <T extends AwsClientBuilder> T configureClient(T builder, AWSCloudSession session, AWSCloudZone zone) {
        builder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)session.getCredentials()));
        builder.region(zone.getRegion());
        return builder;
    }
}

