/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloud;
import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudExplorer;
import com.dbeaver.cloud.aws.AWSCloudService;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.access.DBASession;
import org.jkiss.dbeaver.model.auth.DBAAuthCredentialsProvider;
import org.jkiss.dbeaver.model.auth.DBAAuthSpace;
import org.jkiss.dbeaver.model.auth.DBASessionContext;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class AWSCloudDataSourceOrigin
extends DataSourceOriginCloud<AWSCloud, AWSCloudZone>
implements DBAAuthCredentialsProvider {
    private static final Log log = Log.getLog(AWSCloudDataSourceOrigin.class);
    static final String PROPERTY_RESOURCE_ID = "aws-resource";
    private final String resourceId;

    AWSCloudDataSourceOrigin(@NotNull CloudProviderDescriptor provider, @NotNull AWSCloud cloud, @NotNull AWSCloudZone zone, String resourceId) {
        super(provider, (CPCloud)cloud, (CPCloudZone)zone);
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    @NotNull
    public Map<String, Object> getConfiguration() {
        Map configuration = super.getConfiguration();
        configuration.put(PROPERTY_RESOURCE_ID, this.resourceId);
        return configuration;
    }

    @Nullable
    public DBPObject getObjectDetails(@NotNull DBRProgressMonitor monitor, @NotNull DBASessionContext sessionContext, @NotNull DBPDataSourceContainer dataSource) throws DBException {
        AWSCloudService service = AWSCloudService.getServiceByDriver(dataSource.getDriver());
        if (service == null) {
            log.error((Object)("Cannot detect AWS service for driver " + dataSource.getDriver().getFullName()));
            return null;
        }
        DBASession cloudSession = sessionContext.getSpaceSession((DBAAuthSpace)this.cloud);
        if (cloudSession instanceof AWSCloudSession) {
            AWSCloudAbstractInstance instance = this.findServiceInstance(monitor, (AWSCloudSession)cloudSession, service);
            if (instance == null) {
                log.error((Object)(String.valueOf(service.getServiceId()) + " instance '" + this.resourceId + "' not found"));
            }
            return instance;
        }
        return null;
    }

    private AWSCloudAbstractInstance findServiceInstance(DBRProgressMonitor monitor, AWSCloudSession cloudSession, AWSCloudService service) throws DBException {
        AWSCloudExplorer cloudExplorer = ((AWSCloud)this.cloud).createExplorer(monitor, cloudSession);
        return cloudExplorer.getServiceInstance(monitor, service.getServiceId(), (AWSCloudZone)this.zone, this.resourceId);
    }

    public boolean provideAuthParameters(DBPDataSourceContainer dataSourceContainer, DBPConnectionConfiguration configuration) throws DBException {
        DBASession cloudSession = DBWorkbench.getPlatform().getWorkspace().getAuthContext().getSpaceSession((DBAAuthSpace)this.cloud);
        if (cloudSession instanceof AWSCloudSession) {
            return ((AWSCloudSession)cloudSession).provideAuthParameters(dataSourceContainer, configuration);
        }
        return false;
    }
}

