/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloudConfiguration;
import com.dbeaver.cloud.aws.AWSCloudDataSourceOrigin;
import com.dbeaver.cloud.aws.AWSCloudDataSourceStorage;
import com.dbeaver.cloud.aws.AWSCloudExplorer;
import com.dbeaver.cloud.aws.AWSCloudProvider;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudUtils;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.model.CPCloud;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.auth.DBAAuthSpace;
import org.jkiss.dbeaver.model.auth.DBASessionProviderService;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.model.GetCallerIdentityResponse;

public class AWSCloud
implements CPCloud<AWSCloudZone, AWSCloudSession> {
    private final AWSCloudProvider provider;
    private final AWSCloudConfiguration configuration;
    private AWSCloudDataSourceStorage dataSourceStorage;

    AWSCloud(AWSCloudProvider provider, AWSCloudConfiguration configuration) {
        this.provider = provider;
        this.configuration = configuration;
        this.dataSourceStorage = new AWSCloudDataSourceStorage(this);
    }

    @NotNull
    public AWSCloudZone[] getAllZones() {
        return (AWSCloudZone[])Region.regions().stream().filter(region -> !region.isGlobalRegion()).map(AWSCloudZone::valueOf).toArray(AWSCloudZone[]::new);
    }

    @NotNull
    public AWSCloudConfiguration getCloudConfiguration() {
        return this.configuration;
    }

    @NotNull
    public String getCloudId() {
        return this.configuration.getCloudId();
    }

    @NotNull
    public String getName() {
        return this.configuration.getCloudName();
    }

    @NotNull
    public AWSCloudExplorer createExplorer(@NotNull DBRProgressMonitor monitor, @NotNull AWSCloudSession session) {
        return new AWSCloudExplorer(this, session);
    }

    public boolean isDatabaseServiceSupported(String serviceId) {
        return true;
    }

    public String testConnection(DBRProgressMonitor monitor) throws DBException {
        DBASessionProviderService sessionProviderService = (DBASessionProviderService)DBWorkbench.getService(DBASessionProviderService.class);
        if (sessionProviderService == null) {
            throw new DBException("Can't obtain session provider");
        }
        monitor.beginTask("Connecting to AWS Cloud", 1);
        AWSCloudSession session = (AWSCloudSession)sessionProviderService.acquireSession((DBAAuthSpace)this);
        GetCallerIdentityResponse callerIdentity = this.readGetCallerIdentity(monitor, session);
        monitor.done();
        return callerIdentity.arn();
    }

    public GetCallerIdentityResponse readGetCallerIdentity(DBRProgressMonitor monitor, AWSCloudSession session) {
        monitor.subTask("Ping STS service");
        StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(Region.AWS_GLOBAL)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)session.getCredentials()))).build();
        return stsClient.getCallerIdentity();
    }

    public AWSCloudDataSourceStorage getDataSourceStorage() {
        return this.dataSourceStorage;
    }

    @NotNull
    public AWSCloudZone[] getCloudAssignedZones() {
        ArrayList<AWSCloudZone> awsDefaultZones = new ArrayList<AWSCloudZone>();
        String[] stringArray = this.configuration.getDefaultRegions();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String regionId = stringArray[n2];
            awsDefaultZones.add(AWSCloudZone.valueOf(Region.of((String)regionId)));
            ++n2;
        }
        return awsDefaultZones.toArray(new AWSCloudZone[0]);
    }

    public DBPDataSourceOrigin createOrigin(AWSCloudZone zone, String resourceId) {
        return new AWSCloudDataSourceOrigin(AWSCloudUtils.getAwsCloudProvider(), this, zone, resourceId);
    }

    public boolean equals(Object obj) {
        return obj instanceof AWSCloud && ((AWSCloud)obj).getCloudId().equals(this.getCloudId());
    }
}

