/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor.panel;

import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.editor.panel.VQBPanelQueryCondition;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.sql.format.SQLFormatUtils;
import org.jkiss.utils.CommonUtils;

class VQBPanelQueryWhere
extends VQBPanelQueryCondition {
    protected VQBPanelQueryWhere(VQBEditorPresentation presentation) {
        super(presentation);
    }

    @Override
    protected void updateExpression(PlainSelect plainSelect, Expression expr) {
        plainSelect.setWhere(expr);
    }

    @Override
    protected List<Expression> extractRootItems(PlainSelect inputElement) {
        if (inputElement.getWhere() == null) {
            return null;
        }
        return Collections.singletonList(inputElement.getWhere());
    }

    @Override
    protected boolean supportsTextView() {
        return true;
    }

    @Override
    protected String getEditorText() {
        Expression where;
        PlainSelect plainSelect = this.getPlainSelect();
        if (plainSelect != null && (where = plainSelect.getWhere()) != null) {
            String sql = where.toString();
            DBPDataSource dataSource = this.presentation.getVQBEditor().getDataSource();
            return dataSource == null ? sql : SQLFormatUtils.formatSQL((DBPDataSource)dataSource, (String)sql);
        }
        return "";
    }

    @Override
    protected void updateQueryFromElementsText(String text) throws DBException {
        PlainSelect plainSelect = this.getPlainSelect();
        if (plainSelect != null) {
            try {
                if (CommonUtils.isEmptyTrimmed((String)text)) {
                    this.updateExpression(plainSelect, null);
                } else {
                    Expression newExpression = CCJSqlParserUtil.parseCondExpression((String)text);
                    this.updateExpression(plainSelect, newExpression);
                }
                this.refreshQueryTextFromStatement();
            }
            catch (JSQLParserException e) {
                throw new DBException("Bad expression", (Throwable)e);
            }
        }
    }
}

