/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.spec.ECPoint;
import java.security.spec.X509EncodedKeySpec;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.ECKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class ECPublicKey
extends ECKey
implements java.security.interfaces.ECPublicKey,
PublicKey {
    public ECPublicKey() {
    }

    public ECPublicKey(java.security.interfaces.ECPublicKey eCPublicKey) {
        super(eCPublicKey);
        try {
            ASN1Sequence aSN1Sequence = new ASN1Sequence(new UnsyncByteArrayInputStream(eCPublicKey.getEncoded()));
            this.b = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(0));
            this.c = aSN1Sequence.elementAt(1);
        }
        catch (IOException iOException) {
            System.out.println("Unrecoginzed EC Key Information");
        }
    }

    public ECPublicKey(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public ECPublicKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    @Override
    public byte[] getEncoded() {
        if (this.a == null) {
            return null;
        }
        return ((java.security.interfaces.ECPublicKey)this.a).getEncoded();
    }

    @Override
    public boolean getAllowExport() {
        return true;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public Object clone() {
        byte[] byArray = this.getEncoded();
        if (byArray == null) {
            return null;
        }
        try {
            ECPublicKey eCPublicKey = new ECPublicKey(byArray);
            return eCPublicKey;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        if (!AlgID.ecKey.getOID().equals(algorithmIdentifier.getOID())) {
            throw new AlgorithmIdentifierException("Wrong algorithm identifier for EC key.");
        }
        this.b = algorithmIdentifier;
        this.c = aSN1Object;
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(algorithmIdentifier);
        aSN1Sequence.addElement(aSN1Object);
        this.a = this.a(Utils.toBytes(aSN1Sequence));
    }

    @Override
    public ECPoint getW() {
        if (this.a == null) {
            return null;
        }
        return ((java.security.interfaces.ECPublicKey)this.a).getW();
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(0));
            ASN1Object aSN1Object = aSN1Sequence.elementAt(1);
            this.initialize(algorithmIdentifier, aSN1Object);
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    @Override
    public int length() {
        byte[] byArray = this.getEncoded();
        if (byArray == null) {
            return 0;
        }
        return byArray.length;
    }

    private java.security.interfaces.ECPublicKey a(byte[] byArray) throws InvalidInputException {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return (java.security.interfaces.ECPublicKey)keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new InvalidInputException(generalSecurityException);
        }
    }
}

