/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.ui;

import com.dbeaver.ee.mockdata.engine.model.MockGeneratorDescriptor;
import com.dbeaver.ee.mockdata.ui.EntityProperties;
import com.dbeaver.ee.mockdata.ui.MockDataExecuteWizard;
import com.dbeaver.ee.mockdata.ui.MockDataSettings;
import com.dbeaver.ee.mockdata.ui.internal.MockDataUIMessages;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

public class MockDataWizardPageSettings
extends ActiveWizardPage<MockDataExecuteWizard> {
    private static final Log log = Log.getLog(MockDataWizardPageSettings.class);
    private static final int DEFAULT_NAME_COLUMN_WIDTH = 110;
    private final MockDataSettings mockDataSettings;
    private Tree overviewTree;
    private Combo generatorCombo;
    private PropertyTreeViewer propertiesEditor;
    private Text entityNameText;
    private Button removeOldDataCheck;
    private Text rowsText;
    private Text batchSizeText;
    private boolean firstInit;
    private transient boolean loadingSettings;
    private DBSEntity selectedEntity;
    @Nullable
    private DBSAttributeBase selectedAttribute;
    @Nullable
    private PropertySourceCustom propertySource;

    MockDataWizardPageSettings(MockDataSettings mockDataSettings) {
        super(MockDataUIMessages.tools_mockdata_wizard_page_settings_page_name);
        this.setTitle(MockDataUIMessages.tools_mockdata_wizard_page_settings_page_name);
        this.setDescription(MockDataUIMessages.tools_mockdata_wizard_page_settings_page_description);
        this.mockDataSettings = mockDataSettings;
        this.firstInit = true;
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        SashForm sash = new SashForm(composite, 256);
        sash.setLayoutData((Object)new GridData(1808));
        this.overviewTree = new Tree(UIUtils.createPlaceholder((Composite)sash, (int)1), 67584);
        this.overviewTree.setLayoutData((Object)new GridData(4, 4, true, true));
        UIUtils.createTreeColumn((Tree)this.overviewTree, (int)16384, (String)MockDataUIMessages.tools_mockdata_wizard_page_settings_overview_tree_column_database_objects);
        UIUtils.createTreeColumn((Tree)this.overviewTree, (int)131072, (String)MockDataUIMessages.tools_mockdata_wizard_page_settings_overview_tree_column_generators);
        this.overviewTree.setHeaderVisible(true);
        final Composite settingsComposite = UIUtils.createComposite((Composite)sash, (int)1);
        final Composite generatorPropertiesComposite = UIUtils.createComposite((Composite)settingsComposite, (int)1);
        final Composite entitySettingsComposite = new Composite(settingsComposite, 2048);
        final StackLayout settingsCompositeLayout = new StackLayout();
        settingsComposite.setLayout((Layout)settingsCompositeLayout);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        entitySettingsComposite.setLayout((Layout)layout);
        generatorPropertiesComposite.setLayoutData((Object)new GridData(1808));
        Composite comboAndResetButtonComposite = UIUtils.createComposite((Composite)generatorPropertiesComposite, (int)3);
        comboAndResetButtonComposite.setLayoutData((Object)new GridData(768));
        this.generatorCombo = new Combo(comboAndResetButtonComposite, 12);
        this.generatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MockDataWizardPageSettings.this.selectedAttribute == null) {
                    log.warn((Object)"Attribute is null when clicking on generator combo. There is no target for the chosen generator!");
                    return;
                }
                MockDataWizardPageSettings.this.selectGenerator(MockDataWizardPageSettings.this.selectedEntity, MockDataWizardPageSettings.this.selectedAttribute, MockDataWizardPageSettings.this.generatorCombo.getText());
            }
        });
        GridData gd = new GridData();
        gd.widthHint = UIUtils.getFontHeight((Control)this.generatorCombo) * 20;
        this.generatorCombo.setLayoutData((Object)gd);
        UIUtils.createEmptyLabel((Composite)comboAndResetButtonComposite, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        UIUtils.createDialogButton((Composite)comboAndResetButtonComposite, (String)MockDataUIMessages.tools_mockdata_wizard_page_settings_button_reset, null, (String)MockDataUIMessages.tools_mockdata_wizard_page_settings_button_reset_tooltip, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MockDataWizardPageSettings.this.propertySource == null) {
                    if (MockDataWizardPageSettings.this.selectedAttribute != null) {
                        log.trace((Object)"Property source is null but selected attribute is not");
                    }
                    return;
                }
                for (String key : MockDataWizardPageSettings.this.propertySource.getPropertyValues().keySet()) {
                    MockDataWizardPageSettings.this.propertySource.resetPropertyValueToDefault(key);
                }
                MockDataWizardPageSettings.this.propertiesEditor.loadProperties((DBPPropertySource)MockDataWizardPageSettings.this.propertySource);
                MockDataWizardPageSettings.this.setPropertiesEditorColumnsWidth();
                MockDataWizardPageSettings.this.refreshOverviewTree();
            }
        });
        this.propertiesEditor = new PropertyTreeViewer(generatorPropertiesComposite, 2048);
        this.propertiesEditor.getControl().setLayoutData((Object)new GridData(1808));
        SelectionAdapter changeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MockDataWizardPageSettings.this.updateState(MockDataWizardPageSettings.this.selectedEntity);
            }
        };
        Composite entityComposite = UIUtils.createComposite((Composite)entitySettingsComposite, (int)2);
        this.entityNameText = UIUtils.createLabelText((Composite)entityComposite, (String)MockDataUIMessages.tools_mockdata_wizard_page_settings_text_entity, (String)"", (int)8);
        GridData gd2 = new GridData(768);
        gd2.verticalIndent = 5;
        gd2.horizontalIndent = 9;
        entityComposite.setLayoutData((Object)gd2);
        Group settingsGroup = UIUtils.createControlGroup((Composite)entitySettingsComposite, (String)MockDataUIMessages.tools_mockdata_wizard_page_settings_group_settings, (int)4, (int)768, (int)0);
        gd2 = new GridData(768);
        gd2.verticalIndent = 5;
        settingsGroup.setLayoutData((Object)gd2);
        this.removeOldDataCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)MockDataUIMessages.tools_mockdata_wizard_page_settings_checkbox_remove_old_data, null, (boolean)true, (int)4);
        this.removeOldDataCheck.addSelectionListener((SelectionListener)changeListener);
        this.rowsText = UIUtils.createLabelText((Composite)settingsGroup, (String)MockDataUIMessages.tools_mockdata_wizard_page_settings_combo_rows, (String)String.valueOf(0), (int)2048, (Object)new GridData(110, -1));
        this.rowsText.addSelectionListener((SelectionListener)changeListener);
        this.rowsText.addVerifyListener(UIUtils.getUnsignedLongOrEmptyTextVerifyListener((Text)this.rowsText));
        this.rowsText.addModifyListener(e -> this.updateState(this.selectedEntity));
        this.batchSizeText = UIUtils.createLabelText((Composite)settingsGroup, (String)MockDataUIMessages.tools_mockdata_wizard_page_settings_batch_size, (String)String.valueOf(0), (int)2048, (Object)new GridData(110, -1));
        this.batchSizeText.addSelectionListener((SelectionListener)changeListener);
        this.batchSizeText.addVerifyListener(UIUtils.getUnsignedLongOrEmptyTextVerifyListener((Text)this.batchSizeText));
        this.batchSizeText.addModifyListener(e -> this.updateState(this.selectedEntity));
        this.overviewTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MockDataWizardPageSettings.this.saveGeneratorProperties();
                Object data = e.item.getData();
                if (data instanceof DBSEntity) {
                    if (!Objects.equals(MockDataWizardPageSettings.this.selectedEntity, data)) {
                        MockDataWizardPageSettings.this.updateState(MockDataWizardPageSettings.this.selectedEntity);
                    }
                    MockDataWizardPageSettings.this.selectedEntity = (DBSEntity)data;
                    MockDataWizardPageSettings.this.selectedAttribute = null;
                    MockDataWizardPageSettings.this.propertySource = null;
                    MockDataWizardPageSettings.setCompositeOnTop(settingsComposite, settingsCompositeLayout, entitySettingsComposite);
                    MockDataWizardPageSettings.this.updateGeneralSettings(MockDataWizardPageSettings.this.selectedEntity);
                    return;
                }
                DBSAttributeBase attribute = (DBSAttributeBase)data;
                TreeItem attributeItem = (TreeItem)e.item;
                TreeItem entityItem = attributeItem.getParentItem();
                DBSEntity entity = (DBSEntity)entityItem.getData();
                EntityProperties entityProperties = MockDataWizardPageSettings.this.mockDataSettings.getEntityProperties(entity);
                if (entityProperties == null) {
                    log.trace((Object)("Unable to correctly select attribute " + attribute + ": corresponding entity settings not found"));
                    return;
                }
                EntityProperties.AttributeProperties attributeProperties = entityProperties.getAttributeProperties(attribute);
                MockGeneratorDescriptor descriptor = attributeProperties.getSelectedGenerator();
                MockDataWizardPageSettings.this.reloadProperties(entity, attribute, descriptor == null ? null : descriptor.getId());
                MockDataWizardPageSettings.setCompositeOnTop(settingsComposite, settingsCompositeLayout, generatorPropertiesComposite);
            }
        });
        sash.setWeights(new int[]{40, 60});
        Composite buttonsGroup = new Composite(composite, 0);
        buttonsGroup.setLayoutData((Object)new GridData(768));
        buttonsGroup.setLayout((Layout)new GridLayout(4, false));
        UIUtils.createDialogButton((Composite)buttonsGroup, (String)MockDataUIMessages.tools_mockdata_wizard_page_settings_button_autoassign, null, (String)MockDataUIMessages.tools_mockdata_wizard_page_settings_button_autoassign_tooltip, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (EntityProperties entityProperties : MockDataWizardPageSettings.this.mockDataSettings.getEntityPropertiesList()) {
                    entityProperties.getAttributeGenerators().values().forEach(entityProperties::autoAssignGenerator);
                }
                MockDataWizardPageSettings.this.refreshOverviewTree();
                if (MockDataWizardPageSettings.this.selectedAttribute == null) {
                    return;
                }
                MockDataWizardPageSettings.this.selectGenerator(MockDataWizardPageSettings.this.selectedEntity, MockDataWizardPageSettings.this.selectedAttribute, MockDataWizardPageSettings.this.getAttributeGeneratorLabel(MockDataWizardPageSettings.this.selectedEntity, MockDataWizardPageSettings.this.selectedAttribute));
            }
        });
        UIUtils.createEmptyLabel((Composite)buttonsGroup, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        UIUtils.createDialogButton((Composite)buttonsGroup, (String)MockDataUIMessages.tools_mockdata_wizard_page_settings_button_summary, null, (String)MockDataUIMessages.tools_mockdata_wizard_page_settings_button_summary_tooltip, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShowSummaryDialog dialog = new ShowSummaryDialog(e.display.getActiveShell(), MockDataWizardPageSettings.this.mockDataSettings);
                dialog.open();
            }
        });
        this.setControl((Control)composite);
    }

    private static void setCompositeOnTop(Composite compositeWithStackLayout, StackLayout layout, Composite composite) {
        if (layout.topControl == composite) {
            return;
        }
        layout.topControl = composite;
        compositeWithStackLayout.layout();
    }

    private void selectGenerator(@NotNull DBSEntity entity, @NotNull DBSAttributeBase attribute, @NotNull String generatorName) {
        if (generatorName.isEmpty()) {
            return;
        }
        if (MockDataSettings.NO_GENERATOR_LABEL.equals(generatorName)) {
            this.reloadProperties(entity, attribute, MockDataSettings.NO_GENERATOR_LABEL);
            this.updateGeneratorTextInOverviewTree(entity, attribute);
            return;
        }
        Optional<EntityProperties> opt = this.mockDataSettings.getEntityPropertiesList().stream().filter(properties -> properties.getEntity().equals(entity)).findAny();
        if (!opt.isPresent()) {
            log.trace((Object)("Unable to select generator, no properties found for entity " + entity));
            return;
        }
        MockGeneratorDescriptor generatorForName = opt.get().findGeneratorForName(attribute, generatorName);
        if (generatorForName == null) {
            return;
        }
        this.saveGeneratorProperties();
        this.reloadProperties(entity, attribute, generatorForName.getId());
        this.updateGeneratorTextInOverviewTree(entity, attribute);
    }

    private void updateGeneratorTextInOverviewTree(@NotNull DBSEntity entity, @NotNull DBSAttributeBase attributeBase) {
        String label = this.getAttributeGeneratorLabel(entity, attributeBase);
        TreeItem entityItem = null;
        TreeItem[] treeItemArray = this.overviewTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (entity.equals(item.getData())) {
                entityItem = item;
                break;
            }
            ++n2;
        }
        if (entityItem == null) {
            log.trace((Object)("Unable to update generator text in overview tre: unable to find entity " + entity));
            return;
        }
        TreeItem attributeItem = null;
        TreeItem[] treeItemArray2 = entityItem.getItems();
        int n3 = treeItemArray2.length;
        n = 0;
        while (n < n3) {
            TreeItem item = treeItemArray2[n];
            if (attributeBase.equals(item.getData())) {
                attributeItem = item;
                break;
            }
            ++n;
        }
        if (attributeItem == null) {
            log.trace((Object)("Unable to update generator text in overview tree: unable to find attribute " + attributeBase));
            return;
        }
        attributeItem.setText(1, label);
        this.overviewTree.redraw();
    }

    private void refreshOverviewTree() {
        TreeItem[] roots;
        Collection expandedEntities = Stream.of(this.overviewTree.getItems()).filter(TreeItem::getExpanded).map(treeItem -> (DBSEntity)treeItem.getData()).collect(Collectors.toSet());
        List selectedObjects = Stream.of(this.overviewTree.getSelection()).map(Widget::getData).collect(Collectors.toList());
        this.overviewTree.removeAll();
        ArrayList<TreeItem> newSelection = new ArrayList<TreeItem>(selectedObjects.size());
        for (EntityProperties entityProperties : this.mockDataSettings.getEntityPropertiesList()) {
            DBSEntity entity = entityProperties.getEntity();
            TreeItem entityItem = new TreeItem(this.overviewTree, 0);
            entityItem.setData((Object)entity);
            entityItem.setImage(DBeaverIcons.getImage((DBPImage)entity.getEntityType().getIcon()));
            entityItem.setText(0, DBUtils.getObjectFullName((DBPDataSource)entity.getDataSource(), (DBPNamedObject)entity, (DBPEvaluationContext)DBPEvaluationContext.UI));
            for (DBSAttributeBase attribute : entityProperties.getAttributes()) {
                TreeItem attributeItem = new TreeItem(entityItem, 0);
                attributeItem.setData((Object)attribute);
                attributeItem.setImage(DBeaverIcons.getImage((DBPImage)DBValueFormatting.getTypeImage((DBSTypedObject)attribute)));
                attributeItem.setText(0, attribute.getName().trim());
                attributeItem.setText(1, this.getAttributeGeneratorLabel(entity, attribute));
                if (!selectedObjects.contains(attribute)) continue;
                newSelection.add(attributeItem);
            }
            entityItem.setExpanded(expandedEntities.isEmpty() || expandedEntities.contains(entity));
            if (!selectedObjects.contains(entity)) continue;
            newSelection.add(entityItem);
        }
        if (newSelection.isEmpty() && (roots = this.overviewTree.getItems()).length > 0) {
            newSelection.add(roots[0]);
            this.selectedEntity = (DBSEntity)roots[0].getData();
        }
        this.overviewTree.setSelection(newSelection.toArray(new TreeItem[0]));
        UIUtils.asyncExec(() -> UIUtils.packColumns((Tree)this.overviewTree, (boolean)true, (float[])new float[]{0.35f, 0.65f}));
    }

    private String getAttributeGeneratorLabel(@NotNull DBSEntity entity, @NotNull DBSAttributeBase attribute) {
        EntityProperties entityProperties = this.mockDataSettings.getEntityProperties(entity);
        if (entityProperties == null) {
            return MockDataSettings.NO_GENERATOR_LABEL;
        }
        EntityProperties.AttributeProperties attributeProperties = entityProperties.getAttributeProperties(attribute);
        if (attributeProperties == null || attributeProperties.isEmpty()) {
            return MockDataSettings.NO_GENERATOR_LABEL;
        }
        MockGeneratorDescriptor generatorDescriptor = attributeProperties.getSelectedGenerator();
        if (generatorDescriptor == null) {
            return MockDataSettings.NO_GENERATOR_LABEL;
        }
        return generatorDescriptor.getLabel().trim();
    }

    public void activatePage() {
        EntityProperties entityProperties;
        if (this.firstInit) {
            try {
                UIUtils.run((IRunnableContext)this.getContainer(), (boolean)true, (boolean)true, monitor -> {
                    try {
                        this.firstInit = false;
                        this.mockDataSettings.init(monitor);
                        ((MockDataExecuteWizard)this.getWizard()).loadSettings(monitor);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (InvocationTargetException e) {
                log.warn((Object)"Unable to initialize mock data settings");
                DBWorkbench.getPlatformUI().showError(MockDataUIMessages.tools_mockdata_wizard_page_settings_error_when_loading_settings_title, MockDataUIMessages.tools_mockdata_wizard_page_settings_error_when_loading_settings_message, e.getCause());
                this.setErrorMessage(MockDataUIMessages.tools_mockdata_wizard_page_settings_error_when_loading_settings_wizard_error_message);
            }
            catch (InterruptedException e) {
                log.error((Object)"Mock Data Settings initialization interrupted", (Throwable)e);
            }
            this.loadingSettings = true;
            try {
                EntityProperties entityProperties2 = entityProperties = this.mockDataSettings.getEntityPropertiesList().isEmpty() ? null : this.mockDataSettings.getEntityPropertiesList().get(0);
                if (entityProperties != null) {
                    this.updateGeneralSettings(entityProperties);
                }
                this.refreshOverviewTree();
            }
            finally {
                this.loadingSettings = false;
            }
        }
        EntityProperties entityProperties3 = entityProperties = this.mockDataSettings.getEntityPropertiesList().isEmpty() ? null : this.mockDataSettings.getEntityPropertiesList().get(0);
        if (entityProperties != null) {
            this.entityNameText.setText(MockDataWizardPageSettings.getGeneralSettingsDisplayText(entityProperties));
            this.propertiesEditor.getControl().setFocus();
        }
        if (this.overviewTree.getItemCount() > 0) {
            TreeItem item;
            String selectedAttributeName;
            String entityName = this.mockDataSettings.getSelectedEntityName();
            String string = selectedAttributeName = entityProperties == null ? "" : entityProperties.getSelectedAttribute();
            if (selectedAttributeName != null) {
                item = this.findAttributeItem(entityName, selectedAttributeName);
                if (item == null) {
                    item = this.findEntityItem(entityName);
                }
            } else {
                item = this.findEntityItem(entityName);
            }
            if (item == null) {
                item = this.overviewTree.getItem(0);
            }
            this.overviewTree.select(item);
            this.overviewTree.showItem(item);
            Event event = new Event();
            event.widget = this.overviewTree;
            event.display = this.overviewTree.getDisplay();
            event.item = item;
            event.type = 13;
            this.overviewTree.notifyListeners(13, event);
            this.setMessage(null);
        } else {
            this.setMessage(MockDataUIMessages.tools_mockdata_wizard_page_settings_button_info_noattributes, 1);
        }
        this.updatePageCompletion();
    }

    @NotNull
    private static String getGeneralSettingsDisplayText(@NotNull EntityProperties entityProperties) {
        return DBUtils.getObjectFullName((DBPNamedObject)entityProperties.getEntity(), (DBPEvaluationContext)DBPEvaluationContext.DML);
    }

    private void updateGeneralSettings(@NotNull DBSEntity entity) {
        EntityProperties entityProperties = this.mockDataSettings.getEntityProperties(entity);
        if (entityProperties == null) {
            log.trace((Object)("Unable to update general settings for entity " + entity + ": entity properties not found"));
            return;
        }
        this.updateGeneralSettings(entityProperties);
    }

    private void updateGeneralSettings(@NotNull EntityProperties entityProperties) {
        this.entityNameText.setText(MockDataWizardPageSettings.getGeneralSettingsDisplayText(entityProperties));
        this.removeOldDataCheck.setSelection(entityProperties.isRemoveOldData());
        this.rowsText.setText(String.valueOf(entityProperties.getRowsNumber()));
        this.batchSizeText.setText(String.valueOf(entityProperties.getBatchSize()));
    }

    @Nullable
    private TreeItem findEntityItem(String entityName) {
        TreeItem[] treeItemArray = this.overviewTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getText().equals(entityName)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    private TreeItem findAttributeItem(String entityName, String attributeName) {
        TreeItem entityItem = this.findEntityItem(entityName);
        if (entityItem == null) {
            return null;
        }
        TreeItem[] treeItemArray = entityItem.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getText().equals(attributeName)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public void deactivatePage() {
        this.saveGeneratorProperties();
    }

    public boolean isPageComplete() {
        return true;
    }

    boolean validateProperties() {
        for (EntityProperties entityProperties : this.mockDataSettings.getEntityPropertiesList()) {
            for (EntityProperties.AttributeProperties attributeGeneratorProperties : entityProperties.getAttributeGenerators().values()) {
                PropertySourceCustom generatorProperties = attributeGeneratorProperties.getGeneratorProperties();
                if (generatorProperties == null) continue;
                for (Object value : generatorProperties.getPropertiesWithDefaults().values()) {
                    if (value instanceof Integer && (Integer)value < 0) {
                        return false;
                    }
                    if (!(value instanceof Long) || (Long)value >= 0L) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void updateState(@NotNull DBSEntity entity) {
        if (this.loadingSettings) {
            return;
        }
        EntityProperties properties = this.mockDataSettings.getEntityProperties(entity);
        if (properties == null) {
            log.trace((Object)("Unable to update properties state for entity " + entity));
            return;
        }
        properties.setRemoveOldData(this.removeOldDataCheck.getSelection());
        properties.setRowsNumber(CommonUtils.toLong((Object)this.rowsText.getText()));
        properties.setBatchSize(CommonUtils.toInt((Object)this.batchSizeText.getText()));
    }

    private void reloadProperties(@NotNull DBSEntity entity, @NotNull DBSAttributeBase attribute, String generatorId) {
        EntityProperties entityProperties = this.mockDataSettings.getEntityProperties(entity);
        if (entityProperties == null) {
            log.trace((Object)("Unable to reload properties for attribute " + attribute + ": properties for entity " + entity + "not found"));
            return;
        }
        EntityProperties.AttributeProperties attributeProperties = entityProperties.getAttributeProperties(attribute);
        MockGeneratorDescriptor newGenerator = generatorId == null || MockDataSettings.NO_GENERATOR_LABEL.equals(generatorId) ? null : attributeProperties.getGenerator(generatorId);
        attributeProperties.setSelectedGenerator(newGenerator);
        this.selectedEntity = entity;
        this.selectedAttribute = attribute;
        this.mockDataSettings.setSelectedEntityName(entity.getName());
        entityProperties.setSelectedAttribute(attribute.getName());
        this.propertySource = attributeProperties.getGeneratorProperties();
        if (this.propertySource == null) {
            this.propertiesEditor.clearProperties();
        } else {
            this.propertiesEditor.loadProperties((DBPPropertySource)this.propertySource);
            this.propertiesEditor.setExpandMode(PropertyTreeViewer.ExpandMode.FIRST);
            this.propertiesEditor.expandAll();
        }
        this.setPropertiesEditorColumnsWidth();
        ArrayList<String> generators = new ArrayList<String>();
        generators.add(MockDataSettings.NO_GENERATOR_LABEL);
        for (String genId : attributeProperties.getGenerators()) {
            MockGeneratorDescriptor generatorDescriptor = entityProperties.getGeneratorDescriptor(genId);
            if (generatorDescriptor == null) continue;
            generators.add(generatorDescriptor.getLabel());
        }
        if (!generators.isEmpty()) {
            this.generatorCombo.setItems(generators.toArray(new String[0]));
            MockGeneratorDescriptor generatorDescriptor = entityProperties.getGeneratorDescriptor(generatorId);
            if (generatorDescriptor != null) {
                this.generatorCombo.setText(generatorDescriptor.getLabel());
            } else {
                this.generatorCombo.setText(MockDataSettings.NO_GENERATOR_LABEL);
            }
            this.generatorCombo.setEnabled(true);
        } else {
            this.generatorCombo.setItems(new String[]{MockDataSettings.NO_GENERATOR_LABEL, MockDataUIMessages.tools_mockdata_wizard_page_settings_notfound});
            this.generatorCombo.setText(MockDataUIMessages.tools_mockdata_wizard_page_settings_notfound);
            this.generatorCombo.setEnabled(false);
        }
        this.generatorCombo.getParent().layout();
    }

    private void setPropertiesEditorColumnsWidth() {
        UIUtils.asyncExec(() -> {
            ((Tree)this.propertiesEditor.getControl()).getColumn(0).setWidth(110);
            ((Tree)this.propertiesEditor.getControl()).getColumn(1).setWidth(this.propertiesEditor.getControl().getSize().x - 110 - 30);
        });
    }

    private void saveGeneratorProperties() {
        if (this.propertiesEditor != null) {
            this.propertiesEditor.saveEditorValues();
        }
        if (this.selectedEntity == null || this.selectedAttribute == null) {
            return;
        }
        EntityProperties entityProperties = this.mockDataSettings.getEntityProperties(this.selectedEntity);
        if (entityProperties == null) {
            return;
        }
        EntityProperties.AttributeProperties attributeProperties = entityProperties.getAttributeProperties(this.selectedAttribute);
        MockGeneratorDescriptor selectedGenerator = attributeProperties.getSelectedGenerator();
        if (selectedGenerator == null) {
            return;
        }
        attributeProperties.putGeneratorProperties(selectedGenerator.getId(), this.propertySource);
    }

    private static class ShowSummaryDialog
    extends BaseDialog {
        private static final String INDENT = "  ";
        private static final String DOUBLE_INDENT = "    ";
        private final String text;

        private ShowSummaryDialog(Shell parentShell, MockDataSettings mockDataSettings) {
            super(parentShell, MockDataUIMessages.tools_mockdata_wizard_page_settings_dialog_summary_title, null);
            this.text = ShowSummaryDialog.buildSummary(mockDataSettings);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
        }

        protected void buttonPressed(int buttonId) {
            this.setReturnCode(12);
            this.close();
        }

        private static String buildSummary(MockDataSettings mockDataSettings) {
            StringBuilder builder = new StringBuilder();
            for (EntityProperties entityProperties : mockDataSettings.getEntityPropertiesList()) {
                builder.append("Entity: ").append(entityProperties.getInputObject().getName()).append("\n");
                builder.append(INDENT).append("General settings\n");
                builder.append(DOUBLE_INDENT).append("Remove old data: ").append(entityProperties.isRemoveOldData() ? "yes" : "no").append("\n");
                builder.append(DOUBLE_INDENT).append("Row count: ").append(entityProperties.getRowsNumber()).append("\n");
                builder.append(DOUBLE_INDENT).append("Batch size: ").append(entityProperties.getBatchSize()).append("\n");
                for (DBSAttributeBase attribute : entityProperties.getAttributes()) {
                    builder.append(INDENT).append("Attribute: ").append(attribute.getName().trim()).append("\n");
                    EntityProperties.AttributeProperties properties = entityProperties.getAttributeProperties(attribute);
                    MockGeneratorDescriptor descriptor = properties.getSelectedGenerator();
                    builder.append(DOUBLE_INDENT);
                    if (descriptor == null) {
                        builder.append("No generator selected\n");
                        continue;
                    }
                    builder.append("Generator: ").append(descriptor.getLabel().trim()).append("\n");
                    Map propertyMap = properties.getGeneratorProperties().getPropertiesWithDefaults();
                    for (DBPPropertyDescriptor propertyDescriptor : descriptor.getProperties()) {
                        Object propertyValue = propertyMap.get(propertyDescriptor.getId());
                        if (propertyValue == null) {
                            log.trace((Object)"Unexpected empty property value while building mock data settings summary");
                            continue;
                        }
                        builder.append(DOUBLE_INDENT).append(propertyDescriptor.getDisplayName()).append(": ").append(propertyValue).append("\n");
                    }
                }
            }
            return builder.toString();
        }

        protected Composite createDialogArea(Composite parent) {
            Composite dialogComposite = super.createDialogArea(parent);
            Text textWidget = new Text(dialogComposite, 2568);
            textWidget.setLayoutData((Object)new GridData(1808));
            textWidget.setText(this.text);
            textWidget.setFont(UIUtils.getMonospaceFont());
            return dialogComposite;
        }
    }
}

