/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.ui;

import com.dbeaver.ee.mockdata.ui.EntityProperties;
import com.dbeaver.ee.mockdata.ui.internal.MockDataUIMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.task.DBTTaskSettings;

class MockDataSettings
implements DBTTaskSettings<Collection<DBSObject>> {
    private static final Log log = Log.getLog(MockDataSettings.class);
    private static final String PROP_SELECTED_ENTITY = "selectedEntity";
    static final String NO_GENERATOR_LABEL = MockDataUIMessages.tools_mockdata_attribute_generator_skip;
    private final List<EntityProperties> entityPropertiesList;
    @Nullable
    private String selectedEntityName;
    private boolean isInitialized;

    MockDataSettings(@NotNull Collection<DBSObject> inputObjects) {
        this.entityPropertiesList = new ArrayList<EntityProperties>(inputObjects.size());
        for (DBSObject dbsObject : inputObjects) {
            if (dbsObject == null) continue;
            this.entityPropertiesList.add(new EntityProperties(dbsObject));
        }
    }

    void init(@NotNull DBRProgressMonitor monitor) throws DBException {
        monitor.beginTask("Init mock data settings", 1);
        for (EntityProperties properties : this.entityPropertiesList) {
            properties.init(monitor);
        }
        this.isInitialized = true;
    }

    List<EntityProperties> getEntityPropertiesList() {
        return Collections.unmodifiableList(this.entityPropertiesList);
    }

    void loadFrom(DBRProgressMonitor monitor, @NotNull IDialogSettings dialogSettings) {
        this.selectedEntityName = dialogSettings.get(PROP_SELECTED_ENTITY);
        for (EntityProperties properties : this.entityPropertiesList) {
            properties.loadFrom(monitor, dialogSettings);
        }
    }

    void saveTo(@NotNull IDialogSettings dialogSettings) {
        dialogSettings.put(PROP_SELECTED_ENTITY, this.selectedEntityName == null ? "" : this.selectedEntityName);
        for (EntityProperties properties : this.entityPropertiesList) {
            properties.saveTo(dialogSettings);
        }
    }

    @Nullable
    EntityProperties getEntityProperties(@NotNull DBSEntity entity) {
        return this.entityPropertiesList.stream().filter(properties -> properties.getEntity().equals(entity)).findAny().orElse(null);
    }

    @Nullable
    String getSelectedEntityName() {
        return this.selectedEntityName;
    }

    void setSelectedEntityName(@Nullable String selectedEntityName) {
        this.selectedEntityName = selectedEntityName;
    }

    void sortEntityProperties(DBRProgressMonitor monitor) {
        List entities = this.entityPropertiesList.stream().map(EntityProperties::getEntity).collect(Collectors.toList());
        ArrayList simpleTables = new ArrayList();
        ArrayList cyclicTables = new ArrayList();
        ArrayList views = new ArrayList();
        try {
            DBStructUtils.sortTableList((DBRProgressMonitor)monitor, entities, simpleTables, cyclicTables, views);
        }
        catch (DBException dBException) {
            log.warn((Object)"Unable to sort database entities!");
            return;
        }
        this.entityPropertiesList.sort((properties1, properties2) -> {
            DBSEntity entity1 = properties1.getEntity();
            DBSEntity entity2 = properties2.getEntity();
            int idx1 = views.indexOf(entity1);
            int idx2 = views.indexOf(entity2);
            if (idx1 != -1 || idx2 != -1) {
                return idx1 - idx2;
            }
            idx1 = cyclicTables.indexOf(entity1);
            idx2 = cyclicTables.indexOf(entity2);
            if (idx1 != -1 || idx2 != -1) {
                return idx1 - idx2;
            }
            return simpleTables.indexOf(entity1) - simpleTables.indexOf(entity2);
        });
    }

    boolean isInitialized() {
        return this.isInitialized;
    }
}

