/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.ui;

import com.dbeaver.ee.mockdata.ui.EntityProperties;
import com.dbeaver.ee.mockdata.ui.MockDataSettings;
import com.dbeaver.ee.mockdata.ui.MockDataWizardPageSettings;
import com.dbeaver.ee.mockdata.ui.internal.MockDataUIMessages;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.ui.UIUtils;

class MockDataConfigurationWizardDialog
extends TaskConfigurationWizardDialog {
    private final MockDataSettings mockDataSettings;

    MockDataConfigurationWizardDialog(IWorkbenchWindow window, TaskConfigurationWizard wizard, MockDataSettings mockDataSettings) {
        super(window, wizard);
        this.mockDataSettings = mockDataSettings;
    }

    protected void finishPressed() {
        if (this.validateProperties(this.getCurrentPage())) {
            return;
        }
        int tablesToBeCleaned = 0;
        for (EntityProperties properties : this.mockDataSettings.getEntityPropertiesList()) {
            if (!properties.isRemoveOldData()) continue;
            ++tablesToBeCleaned;
        }
        if (tablesToBeCleaned == 0) {
            super.finishPressed();
            return;
        }
        String question = tablesToBeCleaned > 1 ? NLS.bind((String)MockDataUIMessages.tools_mockdata_wizard_page_settings_confirm_delete_old_data_from_multiple_tables_message, (Object)tablesToBeCleaned) : (this.mockDataSettings.getEntityPropertiesList().size() > 1 ? MockDataUIMessages.tools_mockdata_wizard_page_settings_confirm_delete_old_data_from_one_table_when_generating_data_for_multiple_entities_message : MockDataUIMessages.tools_mockdata_wizard_page_settings_confirm_delete_old_data_message);
        if (!UIUtils.confirmAction((Shell)this.getShell(), (String)MockDataUIMessages.tools_mockdata_wizard_title, (String)question)) {
            return;
        }
        super.finishPressed();
    }

    protected void nextPressed() {
        IWizardPage currentPage = this.getCurrentPage();
        if (currentPage instanceof MockDataWizardPageSettings && this.validateProperties(currentPage)) {
            return;
        }
        super.nextPressed();
    }

    private boolean validateProperties(IWizardPage currentPage) {
        if (currentPage instanceof MockDataWizardPageSettings && !((MockDataWizardPageSettings)currentPage).validateProperties()) {
            this.setErrorMessage(MockDataUIMessages.tools_mockdata_wizard_negative_numeric_error);
            return true;
        }
        return false;
    }

    protected Point getInitialSize() {
        return new Point(850, 550);
    }
}

