/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.common.ui.views;

import com.dbeaver.db.google.auth.GCAuthType;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public abstract class GoogleCloudConnectionPage
extends ConnectionPageAbstract
implements IDialogPageProvider {
    private boolean activated;
    private ModifyListener textListener;
    private Combo authTypeCombo;
    private TextWithOpenFile authConfigFile;
    private Combo projectText;
    private Button useDefaultCredentials;

    public void createControl(Composite composite) {
        Composite group = UIUtils.createComposite((Composite)composite, (int)1);
        group.setLayoutData((Object)new GridData(1808));
        this.createAuthGroup(group);
        this.createSettingsGroup(group);
        this.createDriverPanel(group);
        this.setControl((Control)group);
    }

    protected abstract void createDatabaseGroup(Composite var1);

    private Composite createAuthGroup(Composite parent) {
        this.textListener = e -> {
            if (this.activated) {
                this.saveAndUpdate();
            }
        };
        Group authGroup = UIUtils.createControlGroup((Composite)parent, (String)"Authentication", (int)2, (int)768, (int)0);
        UIUtils.createControlLabel((Composite)authGroup, (String)"Auth type");
        Composite authSettingsPanel = UIUtils.createComposite((Composite)authGroup, (int)2);
        this.authTypeCombo = new Combo(authSettingsPanel, 2060);
        GCAuthType[] gCAuthTypeArray = GCAuthType.values();
        int n = gCAuthTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GCAuthType authType = gCAuthTypeArray[n2];
            this.authTypeCombo.add(authType.getTitle());
            ++n2;
        }
        GridData gd = new GridData(32);
        this.authTypeCombo.setLayoutData((Object)gd);
        this.authTypeCombo.addModifyListener(this.textListener);
        this.authTypeCombo.select(0);
        this.useDefaultCredentials = UIUtils.createCheckbox((Composite)authSettingsPanel, (String)"Use default credentials", (String)"Use application default credentials.\nThey are available if running in Google Compute Engine. Otherwise, the environment variable GOOGLE_APPLICATION_CREDENTIALS must be defined pointing to a file defining the credentials.", (boolean)false, (int)1);
        this.useDefaultCredentials.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GoogleCloudConnectionPage.this.authConfigFile.setEnabled(!GoogleCloudConnectionPage.this.useDefaultCredentials.getSelection());
            }
        });
        UIUtils.createControlLabel((Composite)authGroup, (String)"Auth key file path");
        this.authConfigFile = new TextWithOpenFile((Composite)authGroup, "Google configuration file path", new String[]{"*", "*.p12", "*.json"});
        gd = new GridData(800);
        this.authConfigFile.setLayoutData((Object)gd);
        return authGroup;
    }

    private Composite createSettingsGroup(Composite parent) {
        Group settingsGroup = UIUtils.createControlGroup((Composite)parent, (String)"Settings", (int)2, (int)768, (int)0);
        this.projectText = UIUtils.createLabelCombo((Composite)settingsGroup, (String)"Project", (int)4);
        GridData gd = new GridData(32);
        gd.widthHint = 300;
        this.projectText.setLayoutData((Object)gd);
        this.projectText.addModifyListener(this.textListener);
        this.createDatabaseGroup((Composite)settingsGroup);
        return settingsGroup;
    }

    private void updateCredentialsControls() {
    }

    public boolean isComplete() {
        return !CommonUtils.isEmpty((String)this.projectText.getText()) && this.authTypeCombo.getSelectionIndex() >= 0 && (this.useDefaultCredentials.getSelection() || !CommonUtils.isEmpty((String)this.authConfigFile.getText()));
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        String authType = connectionInfo.getProviderProperty("authType");
        if (!CommonUtils.isEmpty((String)authType)) {
            this.authTypeCombo.select(((GCAuthType)CommonUtils.valueOf(GCAuthType.class, (String)authType, (Enum)GCAuthType.SERVICE_ACCOUNT)).ordinal());
        }
        this.useDefaultCredentials.setSelection(CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("useDefaultCredentials")));
        this.authConfigFile.setText(CommonUtils.toString((Object)connectionInfo.getProviderProperty("credentialsFile")));
        this.projectText.setText(CommonUtils.toString((Object)connectionInfo.getProviderProperty("projectId")));
        this.authConfigFile.setEnabled(!this.useDefaultCredentials.getSelection());
        super.loadSettings();
        this.updateCredentialsControls();
        this.activated = true;
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setProviderProperty("authType", ((GCAuthType)CommonUtils.fromOrdinal(GCAuthType.class, (int)this.authTypeCombo.getSelectionIndex())).name());
        connectionInfo.setProviderProperty("useDefaultCredentials", CommonUtils.toString((Object)this.useDefaultCredentials.getSelection()));
        connectionInfo.setProviderProperty("credentialsFile", this.authConfigFile.getText().trim());
        connectionInfo.setProviderProperty("projectId", this.projectText.getText().trim());
        super.saveSettings(dataSource);
    }

    private void saveAndUpdate() {
        this.site.updateButtons();
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[0];
    }
}

