/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.iam;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jkiss.dbeaver.model.exec.DBCException;
import software.amazon.awssdk.auth.signer.internal.SigningAlgorithm;
import software.amazon.awssdk.utils.BinaryUtils;

public class IAMUtils {
    private static String algorithm = "AWS4-HMAC-SHA256";
    private static String serviceName = "rds-db";
    private static DateTimeFormatter sdf0 = DateTimeFormatter.ofPattern("yyyyMMdd").withZone(ZoneId.of("UTC"));
    private static DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss").withZone(ZoneId.of("UTC"));
    private static String expiryMinutes = "899";

    public static String generateIamPassword(String region, String hostName, int port, String username, String awsAccessKey, String awsSecretKey) throws DBCException {
        Instant now = Instant.now();
        String dateTimeStamp = sdf.format(now);
        String date = sdf0.format(now);
        String portStr = Integer.toString(port);
        List<String> initial = IAMUtils.prepareStrings(username, awsAccessKey, date, dateTimeStamp, region, expiryMinutes, hostName, portStr);
        String requestWithoutSignature = initial.get(0);
        String canonicalString = initial.get(1);
        String stringToSign = IAMUtils.createStringToSign(dateTimeStamp, canonicalString, awsAccessKey, date, region);
        String signature = BinaryUtils.toHex((byte[])IAMUtils.calculateSignature(stringToSign, IAMUtils.newSigningKey(awsSecretKey, date, region, serviceName)));
        String password = IAMUtils.appendSignature(requestWithoutSignature, signature);
        return password;
    }

    private static List<String> prepareStrings(String user, String accessKey, String date, String dateTime, String region, String expiryPeriod, String hostName, String port) throws DBCException {
        TreeMap<String, String> canonicalQueryParameters = new TreeMap<String, String>();
        canonicalQueryParameters.put("Action", "connect");
        canonicalQueryParameters.put("DBUser", user);
        canonicalQueryParameters.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        canonicalQueryParameters.put("X-Amz-Credential", String.valueOf(accessKey) + "%2F" + date + "%2F" + region + "%2F" + "rds-db" + "%2Faws4_request");
        canonicalQueryParameters.put("X-Amz-Date", dateTime);
        canonicalQueryParameters.put("X-Amz-Expires", expiryPeriod);
        canonicalQueryParameters.put("X-Amz-SignedHeaders", "host");
        String canonicalQueryString = "";
        while (!canonicalQueryParameters.isEmpty()) {
            String currentQueryParameter = (String)canonicalQueryParameters.firstKey();
            String currentQueryParameterValue = (String)canonicalQueryParameters.remove(currentQueryParameter);
            canonicalQueryString = String.valueOf(canonicalQueryString) + currentQueryParameter + "=" + currentQueryParameterValue;
            if (currentQueryParameter.equals("X-Amz-SignedHeaders")) continue;
            canonicalQueryString = String.valueOf(canonicalQueryString) + "&";
        }
        String canonicalHeaders = "host:" + hostName + ":" + port + '\n';
        String requestWithoutSignature = String.valueOf(hostName) + ":" + port + "/?" + canonicalQueryString;
        String hashedPayload = BinaryUtils.toHex((byte[])IAMUtils.hash(""));
        String first = requestWithoutSignature;
        String second = "GET\n/\n" + canonicalQueryString + '\n' + canonicalHeaders + '\n' + "host" + '\n' + hashedPayload;
        return Arrays.asList(first, second);
    }

    private static byte[] hash(String s) throws DBCException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(s.getBytes("UTF8"));
            return md.digest();
        }
        catch (Exception e) {
            throw new DBCException("Unable to compute hash while signing request: " + e.getMessage(), (Throwable)e);
        }
    }

    private static String createStringToSign(String dateTime, String canonicalRequest, String accessKey, String date, String region) throws DBCException {
        String credentialScope = String.valueOf(date) + "/" + region + "/" + serviceName + "/aws4_request";
        return String.valueOf(algorithm) + '\n' + dateTime + '\n' + credentialScope + '\n' + BinaryUtils.toHex((byte[])IAMUtils.hash(canonicalRequest));
    }

    private static byte[] calculateSignature(String stringToSign, byte[] signingKey) throws DBCException {
        return IAMUtils.sign(stringToSign.getBytes(Charset.forName("UTF-8")), signingKey, SigningAlgorithm.HmacSHA256);
    }

    private static byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) throws DBCException {
        try {
            Mac mac = algorithm.getMac();
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new DBCException("Unable to calculate a request signature: " + e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] sign(String stringData, byte[] key, SigningAlgorithm algorithm) throws DBCException {
        try {
            byte[] data = stringData.getBytes(StandardCharsets.UTF_8);
            return IAMUtils.sign(data, key, algorithm);
        }
        catch (Exception e) {
            throw new DBCException("Unable to calculate a request signature: " + e.getMessage(), (Throwable)e);
        }
    }

    private static byte[] newSigningKey(String secretKey, String dateStamp, String regionName, String serviceName) throws DBCException {
        byte[] kSecret = ("AWS4" + secretKey).getBytes(Charset.forName("UTF-8"));
        byte[] kDate = IAMUtils.sign(dateStamp, kSecret, SigningAlgorithm.HmacSHA256);
        byte[] kRegion = IAMUtils.sign(regionName, kDate, SigningAlgorithm.HmacSHA256);
        byte[] kService = IAMUtils.sign(serviceName, kRegion, SigningAlgorithm.HmacSHA256);
        return IAMUtils.sign("aws4_request", kService, SigningAlgorithm.HmacSHA256);
    }

    private static String appendSignature(String requestWithoutSignature, String signature) {
        return String.valueOf(requestWithoutSignature) + "&X-Amz-Signature=" + signature;
    }
}

