/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.iam;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.auth.AuthProperty;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AuthModelIAMCredentials
extends AuthModelDatabaseNativeCredentials {
    private static final Log log = Log.getLog(AuthModelIAMCredentials.class);
    public static final String ROLE_SESSION_NAME = "dbeaver";
    private String region;
    private String profileName;
    private boolean defaultAwsCredentials;
    @SecureProperty
    private String awsAccessKey;
    @SecureProperty
    private String awsSecretKey;
    private boolean crossAccountAccess;
    private String awsAccountId;
    private String awsRoleName;

    @Property(hidden=true)
    @AuthProperty(contextProvided=true)
    public String getProfileName() {
        return this.profileName;
    }

    void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    @Property(hidden=true)
    @AuthProperty(contextProvided=true)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Region getAwsRegion() {
        if (CommonUtils.isEmpty((String)this.region)) {
            return Region.AWS_GLOBAL;
        }
        return Region.of((String)this.region);
    }

    @Property(hidden=true)
    @AuthProperty(contextProvided=true)
    public boolean isDefaultAwsCredentials() {
        return this.defaultAwsCredentials;
    }

    void setDefaultAwsCredentials(boolean defaultAwsCredentials) {
        this.defaultAwsCredentials = defaultAwsCredentials;
    }

    @Property
    @AuthProperty(contextProvided=true)
    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    @Property(password=true)
    @AuthProperty(contextProvided=true)
    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public boolean isCrossAccountAccess() {
        return this.crossAccountAccess;
    }

    public void setCrossAccountAccess(boolean crossAccountAccess) {
        this.crossAccountAccess = crossAccountAccess;
    }

    @Property
    @AuthProperty(contextProvided=true)
    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    @Property
    @AuthProperty(contextProvided=true)
    public String getAwsRoleName() {
        return this.awsRoleName;
    }

    void setAwsRoleName(String awsRoleName) {
        this.awsRoleName = awsRoleName;
    }

    public AwsCredentialsProvider getAuthCredentialsProvider(@Nullable DBPConnectionConfiguration configuration) throws DBCException {
        ProfileCredentialsProvider credentialsProvider;
        if (!CommonUtils.isEmpty((String)this.profileName)) {
            if (CommonUtils.isEmpty((String)this.profileName)) {
                throw new DBCException("AWS profile name must be specified");
            }
            credentialsProvider = ProfileCredentialsProvider.builder().profileName(this.profileName).build();
        } else {
            AwsCredentials awsCredentials;
            if (this.defaultAwsCredentials) {
                try {
                    awsCredentials = DefaultCredentialsProvider.builder().reuseLastProviderEnabled(Boolean.valueOf(false)).build().resolveCredentials();
                }
                catch (Exception e) {
                    throw new DBCException("There is no default AWS credentials in system", (Throwable)e);
                }
            }
            String accessKey = this.awsAccessKey;
            String secretKey = this.awsSecretKey;
            if (configuration != null) {
                if (CommonUtils.isEmpty((String)accessKey)) {
                    accessKey = configuration.getUserName();
                }
                if (CommonUtils.isEmpty((String)secretKey)) {
                    secretKey = configuration.getUserPassword();
                }
            }
            if (CommonUtils.isEmpty((String)accessKey) || CommonUtils.isEmpty((String)secretKey)) {
                DBPAuthInfo authInfo;
                try {
                    authInfo = DBWorkbench.getPlatformUI().promptUserCredentials("Please enter access key and secret key", "Access Key", accessKey, "Secret Key", secretKey, false, false);
                }
                catch (Exception e) {
                    authInfo = null;
                    log.error((Object)e);
                }
                if (authInfo != null) {
                    accessKey = authInfo.getUserName();
                    secretKey = authInfo.getUserPassword();
                } else {
                    throw new DBCException("AWS access key and secret key must be specified");
                }
            }
            awsCredentials = AwsBasicCredentials.create((String)accessKey, (String)secretKey);
            credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)awsCredentials);
        }
        if (this.crossAccountAccess && !CommonUtils.isEmpty((String)this.awsAccountId)) {
            if (CommonUtils.isEmpty((String)this.awsRoleName)) {
                throw new DBCException("AWS IAM role name must be specified when 3rd party IAM account is specified");
            }
            Region awsRegion = this.getAwsRegion();
            String roleArn = "arn:aws:iam::" + this.awsAccountId + ":role/" + this.awsRoleName;
            StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(awsRegion)).credentialsProvider((AwsCredentialsProvider)credentialsProvider)).build();
            AssumeRoleRequest arRequest = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(ROLE_SESSION_NAME).build();
            credentialsProvider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(arRequest).build();
        }
        return credentialsProvider;
    }
}

