/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class EnvironmentVariable
implements Serializable {
    static final long serialVersionUID = 4L;
    static final int RV_ENOENT = 3025;
    static final int RV_EPERM = 3027;
    static final int RV_ENOSPC = 3404;
    static final ProgramParameter nullParameter = new ProgramParameter();
    private AS400 system_ = null;
    private transient ServiceProgramCall spc_ = null;
    private transient Converter converter_ = null;
    private String name_ = null;
    private byte[] nameBytes_ = null;
    private transient String value_ = null;
    private transient byte[] valueBytes_ = null;
    private transient int ccsid_ = 0;
    private int stringType_ = 0;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;

    static ServiceProgramCall setupServiceProgramCall(AS400 aS400) {
        if (aS400 == null) {
            Trace.log(2, "Attempt to connect before setting system.");
            throw new ExtendedIllegalStateException("system", 4);
        }
        ServiceProgramCall serviceProgramCall = new ServiceProgramCall(aS400);
        try {
            serviceProgramCall.setProgram("/QSYS.LIB/QP0ZSYSE.SRVPGM");
            serviceProgramCall.suggestThreadsafe();
            serviceProgramCall.setReturnValueFormat(1);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10);
        }
        return serviceProgramCall;
    }

    static int runServiceProgram(ServiceProgramCall serviceProgramCall, String string, ProgramParameter[] programParameterArray, int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ServiceProgramCall serviceProgramCall2 = serviceProgramCall;
        synchronized (serviceProgramCall2) {
            if (Trace.traceOn_) {
                Trace.log(3, "Calling service program procedure: " + string);
            }
            try {
                serviceProgramCall.setProcedureName(string);
                serviceProgramCall.setParameterList(programParameterArray);
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
                throw new InternalErrorException(10);
            }
            if (serviceProgramCall.run()) {
                int n3 = serviceProgramCall.getIntegerReturnValue();
                if (Trace.traceOn_) {
                    Trace.log(3, "Service program procedure: " + string + ", returned value: " + n3);
                }
                if (n3 == 0 || n3 == n || n3 == n2) {
                    return n3;
                }
                if (n3 == 3027) {
                    Trace.log(2, "*JOBCTL special authority required to add, change, or delete system-level environment variable.");
                    throw new AS400SecurityException(40);
                }
                Trace.log(2, "Service program return value was unexpected.");
                throw new InternalErrorException(9);
            }
            if (Trace.traceOn_) {
                Trace.log(3, "Service program procedure: " + string + ", failed.");
            }
            throw new AS400Exception(serviceProgramCall.getMessageList());
        }
    }

    public EnvironmentVariable() {
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing EnvironmentVariable object.");
        }
    }

    public EnvironmentVariable(AS400 aS400) {
        this();
        if (Trace.traceOn_) {
            Trace.log(1, " system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    public EnvironmentVariable(AS400 aS400, String string) {
        this(aS400);
        if (Trace.traceOn_) {
            Trace.log(1, " name: '" + string + "'");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (string.indexOf(32) >= 0 || string.indexOf(61) >= 0) {
            Trace.log(2, "Value of parameter 'name' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("name (" + string + ")", 2);
        }
        this.name_ = string;
    }

    EnvironmentVariable(AS400 aS400, ServiceProgramCall serviceProgramCall, String string) throws IOException {
        this(aS400, string);
        this.spc_ = serviceProgramCall;
    }

    EnvironmentVariable(AS400 aS400, ServiceProgramCall serviceProgramCall, byte[] byArray, byte[] byArray2, int n) throws IOException {
        this();
        this.system_ = aS400;
        this.spc_ = serviceProgramCall;
        this.converter_ = new Converter(n, aS400);
        this.nameBytes_ = byArray;
        this.valueBytes_ = byArray2;
        this.ccsid_ = n;
        this.stringType_ = AS400BidiTransform.getStringType(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        EnvironmentVariable environmentVariable = this;
        synchronized (environmentVariable) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n;
        Object[] objectArray;
        if (Trace.traceOn_) {
            Trace.log(1, "Deleting environment variable.");
        }
        if (this.name_ == null && this.nameBytes_ == null) {
            Trace.log(2, "Attempt to delete before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.spc_ == null) {
            this.spc_ = EnvironmentVariable.setupServiceProgramCall(this.system_);
        }
        if (this.converter_ == null) {
            this.converter_ = new Converter(this.system_.getCcsid(), this.system_);
        }
        if (this.nameBytes_ == null) {
            objectArray = this.converter_.stringToByteArray(this.name_, this.stringType_);
            this.nameBytes_ = new byte[objectArray.length + 1];
            System.arraycopy(objectArray, 0, this.nameBytes_, 0, objectArray.length);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Name bytes:", this.nameBytes_);
        }
        if ((n = EnvironmentVariable.runServiceProgram(this.spc_, "Qp0zDltSysEnv", (ProgramParameter[])(objectArray = (Object[])new ProgramParameter[]{new ProgramParameter(2, this.nameBytes_), nullParameter}), 3025, 0)) == 3025) {
            Trace.log(2, "Environment variable does not exist.");
            throw new ObjectDoesNotExistException(this.getName(), 2);
        }
        this.value_ = null;
        this.valueBytes_ = null;
        this.ccsid_ = 0;
        this.stringType_ = 0;
    }

    public int getCCSID() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting environment variable CCSID.");
        }
        if (this.ccsid_ == 0) {
            this.refreshValue();
        }
        if (Trace.traceOn_) {
            Trace.log(1, "CCSID:", this.ccsid_);
        }
        return this.ccsid_;
    }

    public String getName() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting environment variable name.");
        }
        if (this.name_ == null && this.nameBytes_ != null) {
            this.name_ = this.converter_.byteArrayToString(this.nameBytes_, 0, this.nameBytes_.length - 1, this.stringType_);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Name: " + this.name_);
        }
        return this.name_;
    }

    public String getName(int n) {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting environment variable name.");
        }
        if (this.stringType_ != n && this.nameBytes_ != null) {
            this.name_ = this.converter_.byteArrayToString(this.nameBytes_, 0, this.nameBytes_.length - 1, n);
        }
        this.stringType_ = n;
        return this.getName();
    }

    public AS400 getSystem() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting system: " + this.system_);
        }
        return this.system_;
    }

    public String getValue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting environment variable value.");
        }
        if (this.value_ == null) {
            if (this.valueBytes_ == null) {
                this.refreshValue();
            }
            this.value_ = this.converter_.byteArrayToString(this.valueBytes_, 0, this.valueBytes_.length - 1, this.stringType_);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Value: " + this.value_);
        }
        return this.value_;
    }

    public String getValue(int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.stringType_ = n;
        return this.getValue();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.spc_ = null;
        this.converter_ = null;
        this.value_ = null;
        this.valueBytes_ = null;
        this.ccsid_ = 0;
        this.propertyChangeListeners_ = null;
    }

    public void refreshValue() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Object[] objectArray;
        if (Trace.traceOn_) {
            Trace.log(1, "Refreshing environment variable value.");
        }
        if (this.name_ == null && this.nameBytes_ == null) {
            Trace.log(2, "Attempt to refresh before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.spc_ == null) {
            this.spc_ = EnvironmentVariable.setupServiceProgramCall(this.system_);
        }
        if (this.converter_ == null) {
            this.converter_ = new Converter(this.system_.getCcsid(), this.system_);
        }
        if (this.nameBytes_ == null) {
            objectArray = this.converter_.stringToByteArray(this.name_, this.stringType_);
            this.nameBytes_ = new byte[objectArray.length + 1];
            System.arraycopy(objectArray, 0, this.nameBytes_, 0, objectArray.length);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Name bytes:", this.nameBytes_);
        }
        objectArray = new ProgramParameter[]{new ProgramParameter(2, this.nameBytes_), new ProgramParameter(2, 1024), new ProgramParameter(2, new byte[]{0, 0, 4, 0}, 4), new ProgramParameter(2, 4), nullParameter};
        int n = EnvironmentVariable.runServiceProgram(this.spc_, "Qp0zGetSysEnv", (ProgramParameter[])objectArray, 3404, 3025);
        int n2 = BinaryConverter.byteArrayToInt(objectArray[2].getOutputData(), 0);
        if (n == 3404) {
            if (Trace.traceOn_) {
                Trace.log(3, "ENOSPC returned, getting environment variable again with " + n2 + " bytes.");
            }
            try {
                objectArray[1].setOutputDataLength(n2);
                objectArray[2].setInputData(BinaryConverter.intToByteArray(n2));
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
                throw new InternalErrorException(10);
            }
            EnvironmentVariable.runServiceProgram(this.spc_, "Qp0zGetSysEnv", (ProgramParameter[])objectArray, 0, 0);
        } else if (n == 3025) {
            Trace.log(2, "Environment variable does not exist.");
            throw new ObjectDoesNotExistException(this.getName(), 2);
        }
        this.valueBytes_ = new byte[n2];
        System.arraycopy(objectArray[1].getOutputData(), 0, this.valueBytes_, 0, n2);
        if (Trace.traceOn_) {
            Trace.log(1, "Value bytes:", this.valueBytes_);
        }
        this.value_ = null;
        int n3 = BinaryConverter.byteArrayToInt(objectArray[3].getOutputData(), 0);
        if (Trace.traceOn_) {
            Trace.log(1, "CCSID:", n3);
        }
        if (n3 != this.ccsid_) {
            this.converter_ = new Converter(n3, this.system_);
            this.ccsid_ = n3;
            this.stringType_ = AS400BidiTransform.getStringType(n3);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void setName(String string) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting environment variable name: '" + string + "'");
        }
        if (string == null) {
            Trace.log(2, "Parameter 'name' is null.");
            throw new NullPointerException("name");
        }
        if (string.indexOf(32) >= 0 || string.indexOf(61) >= 0) {
            Trace.log(2, "Value of parameter 'name' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("name (" + string + ")", 2);
        }
        this.nameBytes_ = null;
        this.value_ = null;
        this.valueBytes_ = null;
        this.ccsid_ = 0;
        this.stringType_ = 0;
        if (this.propertyChangeListeners_ == null) {
            this.name_ = string;
        } else {
            String string2;
            String string3 = this.name_;
            this.name_ = string2 = string;
            this.propertyChangeListeners_.firePropertyChange("name", string3, string2);
        }
    }

    public void setName(String string, int n) {
        this.setName(string);
        this.stringType_ = n;
    }

    public void setSystem(AS400 aS400) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting system: " + aS400);
        }
        if (aS400 == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        if (this.spc_ != null) {
            Trace.log(2, "Cannot set property 'system' after connect.");
            throw new ExtendedIllegalStateException("system", 5);
        }
        if (this.propertyChangeListeners_ == null) {
            this.system_ = aS400;
        } else {
            AS400 aS4002;
            AS400 aS4003 = this.system_;
            this.system_ = aS4002 = aS400;
            this.propertyChangeListeners_.firePropertyChange("system", aS4003, aS4002);
        }
    }

    public void setValue(String string) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setValue(string, 0, 0);
    }

    public void setValue(String string, int n) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        this.setValue(string, n, AS400BidiTransform.getStringType(n));
    }

    public void setValue(String string, int n, int n2) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        byte[] byArray;
        if (Trace.traceOn_) {
            Trace.log(1, "Setting environment variable value: '" + string + "', ccsid: " + n + ", string type: " + n2);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'value' is null.");
            throw new NullPointerException("value");
        }
        if (n < 0 || n > 65535) {
            Trace.log(2, "Value of parameter 'ccsid' is not valid:", n);
            throw new ExtendedIllegalArgumentException("ccsid (" + n + ")", 2);
        }
        if (this.name_ == null && this.nameBytes_ == null) {
            Trace.log(2, "Attempt to set value before setting name.");
            throw new ExtendedIllegalStateException("name", 4);
        }
        if (this.spc_ == null) {
            this.spc_ = EnvironmentVariable.setupServiceProgramCall(this.system_);
        }
        if (n == 0) {
            n = this.system_.getCcsid();
        }
        this.converter_ = new Converter(n, this.system_);
        this.ccsid_ = n;
        this.stringType_ = n2;
        if (this.nameBytes_ == null) {
            byArray = this.converter_.stringToByteArray(this.name_, this.stringType_);
            this.nameBytes_ = new byte[byArray.length + 1];
            System.arraycopy(byArray, 0, this.nameBytes_, 0, byArray.length);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Name bytes:", this.nameBytes_);
        }
        byArray = this.converter_.stringToByteArray(string, this.stringType_);
        this.valueBytes_ = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, this.valueBytes_, 0, byArray.length);
        if (Trace.traceOn_) {
            Trace.log(1, "Value bytes:", this.valueBytes_);
        }
        byte[] byArray2 = new byte[this.nameBytes_.length + this.valueBytes_.length];
        System.arraycopy(this.nameBytes_, 0, byArray2, 0, this.nameBytes_.length - 1);
        byArray2[this.nameBytes_.length - 1] = 126;
        System.arraycopy(this.valueBytes_, 0, byArray2, this.nameBytes_.length, this.valueBytes_.length);
        ProgramParameter[] programParameterArray = new ProgramParameter[]{new ProgramParameter(2, byArray2), new ProgramParameter(1, BinaryConverter.intToByteArray(n)), nullParameter};
        EnvironmentVariable.runServiceProgram(this.spc_, "Qp0zPutSysEnv", programParameterArray, 0, 0);
    }

    static {
        try {
            nullParameter.setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, "Unexpected PropertyVetoException:", (Throwable)propertyVetoException);
            throw new InternalErrorException(10);
        }
    }
}

