/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchdb.model;

import com.dbeaver.db.couchdb.CouchDBUtils;
import com.dbeaver.db.couchdb.model.CouchDBDataSourceInfo;
import com.dbeaver.db.couchdb.model.CouchDBDatabase;
import com.dbeaver.db.couchdb.model.CouchDBSQLDialect;
import com.dbeaver.ee.model.NoSQLDataType;
import com.dbeaver.ee.model.document.DocumentDataManager;
import com.dbeaver.ee.model.document.data.DBDocumentUtils;
import com.dbeaver.ee.model.document.data.DBMapValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.utils.IntKeyMap;

public class CouchDBDataSource
implements DBPDataSource,
DocumentDataManager<CouchDBDataSource, JsonObject>,
DBSObjectContainer,
DBPRefreshableObject,
DBPDataTypeProvider,
IAdaptable,
DBCQueryTransformProvider {
    private static final Log log = Log.getLog(CouchDBDataSource.class);
    public static Gson GSON = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").setLenient().serializeNulls().create();
    private final DBPDataSourceContainer container;
    private IntKeyMap<NoSQLDataType> dataTypes;
    private CouchDBDatabase defaultDatabase;
    private CouchDBDataSourceInfo info;
    private final DatabaseCache databaseCache = new DatabaseCache();

    public CouchDBDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        this.container = container;
        this.dataTypes = DBDocumentUtils.makeDocumentDataTypes((DBPDataSource)this);
        this.defaultDatabase = new CouchDBDatabase(monitor, this, container.getConnectionConfiguration().getDatabaseName(), true);
    }

    @NotNull
    public DBPDataSourceContainer getContainer() {
        return this.container;
    }

    @NotNull
    public CouchDBDatabase getDefaultInstance() {
        return this.defaultDatabase;
    }

    @NotNull
    public List<CouchDBDatabase> getAvailableInstances() {
        return this.databaseCache.getCachedObjects();
    }

    public SQLDialect getSQLDialect() {
        return CouchDBSQLDialect.INSTANCE;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.info = new CouchDBDataSourceInfo(this);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return null;
        }
        if (adapter == DBCQueryTransformProvider.class) {
            return adapter.cast(this);
        }
        return null;
    }

    public void shutdown(DBRProgressMonitor monitor) {
        this.databaseCache.clearCache();
    }

    public List<CouchDBDatabase> getDatabases(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.databaseCache.getAllObjects(monitor, this);
    }

    public List<CouchDBDatabase> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getDatabases(monitor);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.databaseCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<CouchDBDatabase> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return CouchDBDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.databaseCache.getAllObjects(monitor, this);
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        for (NoSQLDataType dt : this.dataTypes.values()) {
            if (dt.getTypeID() != typeID && !dt.getTypeName().equals(typeName)) continue;
            return dt.getDataKind();
        }
        return DBPDataKind.OBJECT;
    }

    public DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        return this.getLocalDataType(typeFullName);
    }

    public List<DBSDataType> getLocalDataTypes() {
        return new ArrayList<DBSDataType>(this.dataTypes.values());
    }

    public DBSDataType getLocalDataType(String typeName) {
        for (NoSQLDataType dt : this.dataTypes.values()) {
            if (!dt.getTypeName().equals(typeName)) continue;
            return dt;
        }
        return null;
    }

    public DBSDataType getLocalDataType(int typeID) {
        return (DBSDataType)this.dataTypes.get(typeID);
    }

    public DBSDataType getDocumentDataType(int typeId) {
        return (DBSDataType)this.dataTypes.get(typeId);
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return NoSQLDataType.TypeName.STRING.getTypeName();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.databaseCache.clearCache();
        return this;
    }

    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false, true);
        }
        return null;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.container;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this;
    }

    @NotNull
    public String getName() {
        return this.container.getName();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return false;
    }

    public void serializeDocument(JsonObject document, Writer writer) {
        GSON.toJson((JsonElement)document, (Appendable)writer);
    }

    public Map<String, Object> deserializeDocument(Reader reader) {
        return JSONUtils.parseMap((Gson)GSON, (Reader)reader);
    }

    public DBMapValue<CouchDBDataSource> convertNativeDocumentToMap(JsonObject jsonObject) {
        return CouchDBUtils.makeMapValue(this, null, jsonObject);
    }

    public JsonObject convertMapToNativeDocument(DBMapValue<CouchDBDataSource> map) {
        return (JsonObject)this.getDefaultInstance().getClient().getGson().toJsonTree((Object)map.getRawValue());
    }

    public class DatabaseCache
    extends BasicObjectCache<CouchDBDataSource, CouchDBDatabase> {
        @NotNull
        public List<CouchDBDatabase> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CouchDBDataSource dataSource) throws DBCException {
            if (!this.isFullyCached()) {
                ArrayList<CouchDBDatabase> result = new ArrayList<CouchDBDatabase>();
                for (String dbName : CouchDBDataSource.this.defaultDatabase.getClient().context().getAllDbs()) {
                    if (dbName.equals(CouchDBDataSource.this.defaultDatabase.getName())) {
                        result.add(CouchDBDataSource.this.defaultDatabase);
                        continue;
                    }
                    result.add(new CouchDBDatabase(monitor, dataSource, dbName, true));
                }
                this.setCache(result);
            }
            return this.getCachedObjects();
        }
    }
}

