/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.lakeformation.model;

import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.protocol.ProtocolMarshaller;
import com.simba.athena.amazonaws.protocol.StructuredPojo;
import com.simba.athena.amazonaws.services.lakeformation.model.DataLakePrincipal;
import com.simba.athena.amazonaws.services.lakeformation.model.Permission;
import com.simba.athena.amazonaws.services.lakeformation.model.Resource;
import com.simba.athena.amazonaws.services.lakeformation.model.transform.PrincipalResourcePermissionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PrincipalResourcePermissions
implements Serializable,
Cloneable,
StructuredPojo {
    private DataLakePrincipal principal;
    private Resource resource;
    private List<String> permissions;
    private List<String> permissionsWithGrantOption;

    public void setPrincipal(DataLakePrincipal principal) {
        this.principal = principal;
    }

    public DataLakePrincipal getPrincipal() {
        return this.principal;
    }

    public PrincipalResourcePermissions withPrincipal(DataLakePrincipal principal) {
        this.setPrincipal(principal);
        return this;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public PrincipalResourcePermissions withResource(Resource resource) {
        this.setResource(resource);
        return this;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<String> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<String>(permissions);
    }

    public PrincipalResourcePermissions withPermissions(String ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<String>(permissions.length));
        }
        for (String ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public PrincipalResourcePermissions withPermissions(Collection<String> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public PrincipalResourcePermissions withPermissions(Permission ... permissions) {
        ArrayList<String> permissionsCopy = new ArrayList<String>(permissions.length);
        for (Permission value : permissions) {
            permissionsCopy.add(value.toString());
        }
        if (this.getPermissions() == null) {
            this.setPermissions(permissionsCopy);
        } else {
            this.getPermissions().addAll(permissionsCopy);
        }
        return this;
    }

    public List<String> getPermissionsWithGrantOption() {
        return this.permissionsWithGrantOption;
    }

    public void setPermissionsWithGrantOption(Collection<String> permissionsWithGrantOption) {
        if (permissionsWithGrantOption == null) {
            this.permissionsWithGrantOption = null;
            return;
        }
        this.permissionsWithGrantOption = new ArrayList<String>(permissionsWithGrantOption);
    }

    public PrincipalResourcePermissions withPermissionsWithGrantOption(String ... permissionsWithGrantOption) {
        if (this.permissionsWithGrantOption == null) {
            this.setPermissionsWithGrantOption(new ArrayList<String>(permissionsWithGrantOption.length));
        }
        for (String ele : permissionsWithGrantOption) {
            this.permissionsWithGrantOption.add(ele);
        }
        return this;
    }

    public PrincipalResourcePermissions withPermissionsWithGrantOption(Collection<String> permissionsWithGrantOption) {
        this.setPermissionsWithGrantOption(permissionsWithGrantOption);
        return this;
    }

    public PrincipalResourcePermissions withPermissionsWithGrantOption(Permission ... permissionsWithGrantOption) {
        ArrayList<String> permissionsWithGrantOptionCopy = new ArrayList<String>(permissionsWithGrantOption.length);
        for (Permission value : permissionsWithGrantOption) {
            permissionsWithGrantOptionCopy.add(value.toString());
        }
        if (this.getPermissionsWithGrantOption() == null) {
            this.setPermissionsWithGrantOption(permissionsWithGrantOptionCopy);
        } else {
            this.getPermissionsWithGrantOption().addAll(permissionsWithGrantOptionCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPrincipal() != null) {
            sb.append("Principal: ").append(this.getPrincipal()).append(",");
        }
        if (this.getResource() != null) {
            sb.append("Resource: ").append(this.getResource()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions()).append(",");
        }
        if (this.getPermissionsWithGrantOption() != null) {
            sb.append("PermissionsWithGrantOption: ").append(this.getPermissionsWithGrantOption());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalResourcePermissions)) {
            return false;
        }
        PrincipalResourcePermissions other = (PrincipalResourcePermissions)obj;
        if (other.getPrincipal() == null ^ this.getPrincipal() == null) {
            return false;
        }
        if (other.getPrincipal() != null && !other.getPrincipal().equals(this.getPrincipal())) {
            return false;
        }
        if (other.getResource() == null ^ this.getResource() == null) {
            return false;
        }
        if (other.getResource() != null && !other.getResource().equals(this.getResource())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        if (other.getPermissions() != null && !other.getPermissions().equals(this.getPermissions())) {
            return false;
        }
        if (other.getPermissionsWithGrantOption() == null ^ this.getPermissionsWithGrantOption() == null) {
            return false;
        }
        return other.getPermissionsWithGrantOption() == null || other.getPermissionsWithGrantOption().equals(this.getPermissionsWithGrantOption());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPrincipal() == null ? 0 : this.getPrincipal().hashCode());
        hashCode = 31 * hashCode + (this.getResource() == null ? 0 : this.getResource().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getPermissionsWithGrantOption() == null ? 0 : this.getPermissionsWithGrantOption().hashCode());
        return hashCode;
    }

    public PrincipalResourcePermissions clone() {
        try {
            return (PrincipalResourcePermissions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PrincipalResourcePermissionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

