/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.auth;

import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import com.simba.athena.amazonaws.AmazonClientException;
import com.simba.athena.amazonaws.AmazonServiceException;
import com.simba.athena.amazonaws.AmazonWebServiceRequest;
import com.simba.athena.amazonaws.ClientConfiguration;
import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.auth.AWSStaticCredentialsProvider;
import com.simba.athena.amazonaws.auth.AnonymousAWSCredentials;
import com.simba.athena.amazonaws.auth.RefreshableTask;
import com.simba.athena.amazonaws.auth.SessionCredentialsHolder;
import com.simba.athena.amazonaws.auth.ShouldDoAsyncSessionRefresh;
import com.simba.athena.amazonaws.auth.ShouldDoBlockingSessionRefresh;
import com.simba.athena.amazonaws.retry.PredefinedBackoffStrategies;
import com.simba.athena.amazonaws.retry.RetryPolicy;
import com.simba.athena.amazonaws.retry.RetryUtils;
import com.simba.athena.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.simba.athena.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.simba.athena.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import com.simba.athena.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import com.simba.athena.amazonaws.services.securitytoken.model.IDPCommunicationErrorException;
import com.simba.athena.amazonaws.services.securitytoken.model.InvalidIdentityTokenException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;

public class STSAssumeRoleWithWebIdentitySessionCredentialsProvider
implements AWSSessionCredentialsProvider,
Closeable {
    private final AWSSecurityTokenService securityTokenService;
    private final String roleArn;
    private final String roleSessionName;
    private final String webIdentityTokenFile;
    private final Callable<SessionCredentialsHolder> refreshCallable = new Callable<SessionCredentialsHolder>(){

        @Override
        public SessionCredentialsHolder call() throws Exception {
            return STSAssumeRoleWithWebIdentitySessionCredentialsProvider.this.newSession();
        }
    };
    private volatile RefreshableTask<SessionCredentialsHolder> refreshableTask;

    private RefreshableTask<SessionCredentialsHolder> createRefreshableTask() {
        return new RefreshableTask.Builder<SessionCredentialsHolder>().withRefreshCallable(this.refreshCallable).withBlockingRefreshPredicate(new ShouldDoBlockingSessionRefresh()).withAsyncRefreshPredicate(new ShouldDoAsyncSessionRefresh()).build();
    }

    private STSAssumeRoleWithWebIdentitySessionCredentialsProvider(Builder builder) {
        this.roleArn = builder.roleArn;
        this.roleSessionName = builder.roleSessionName;
        this.webIdentityTokenFile = builder.webIdentityTokenFile;
        this.securityTokenService = STSAssumeRoleWithWebIdentitySessionCredentialsProvider.buildStsClient(builder);
        this.refreshableTask = this.createRefreshableTask();
    }

    private static AWSSecurityTokenService buildStsClient(Builder builder) throws IllegalArgumentException {
        if (builder.sts != null) {
            return builder.sts;
        }
        RetryPolicy retryPolicy = new RetryPolicy(new StsRetryCondition(), new PredefinedBackoffStrategies.SDKDefaultBackoffStrategy(), 3, true);
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setRetryPolicy(retryPolicy);
        return (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials(new AWSStaticCredentialsProvider(new AnonymousAWSCredentials()))).build();
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        return this.refreshableTask.getValue().getSessionCredentials();
    }

    @Override
    public void refresh() {
        this.refreshableTask.forceGetValue();
    }

    private SessionCredentialsHolder newSession() {
        AssumeRoleWithWebIdentityRequest assumeRoleRequest = new AssumeRoleWithWebIdentityRequest().withRoleArn(this.roleArn).withWebIdentityToken(this.getWebIdentityToken()).withRoleSessionName(this.roleSessionName);
        AssumeRoleWithWebIdentityResult assumeRoleResult = this.securityTokenService.assumeRoleWithWebIdentity(assumeRoleRequest);
        return new SessionCredentialsHolder(assumeRoleResult.getCredentials());
    }

    private String getWebIdentityToken() {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.webIdentityTokenFile), "UTF-8"));
            String string = br.readLine();
            return string;
        }
        catch (FileNotFoundException e) {
            throw new SdkClientException("Unable to locate specified web identity token file: " + this.webIdentityTokenFile);
        }
        catch (IOException e) {
            throw new SdkClientException("Unable to read web identity token from file: " + this.webIdentityTokenFile);
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void close() {
        this.refreshableTask.close();
    }

    private static class StsRetryCondition
    implements RetryPolicy.RetryCondition {
        private StsRetryCondition() {
        }

        @Override
        public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
            if (exception.getCause() instanceof IOException) {
                return true;
            }
            if (exception.getCause() instanceof InvalidIdentityTokenException) {
                return true;
            }
            if (exception.getCause() instanceof IDPCommunicationErrorException) {
                return true;
            }
            if (exception instanceof AmazonServiceException) {
                AmazonServiceException ase = (AmazonServiceException)exception;
                if (RetryUtils.isRetryableServiceException(ase)) {
                    return true;
                }
                if (RetryUtils.isThrottlingException(ase)) {
                    return true;
                }
                if (RetryUtils.isClockSkewError(ase)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static final class Builder {
        private final String roleArn;
        private final String roleSessionName;
        private final String webIdentityTokenFile;
        private AWSSecurityTokenService sts;

        public Builder(String roleArn, String roleSessionName, String webIdentityTokenFile) {
            if (roleArn == null || roleSessionName == null || webIdentityTokenFile == null) {
                throw new NullPointerException("You must specify a value for roleArn, roleSessionName and webIdentityTokenFile");
            }
            this.roleArn = roleArn;
            this.roleSessionName = roleSessionName;
            this.webIdentityTokenFile = webIdentityTokenFile;
        }

        public Builder withStsClient(AWSSecurityTokenService sts) {
            this.sts = sts;
            return this;
        }

        public STSAssumeRoleWithWebIdentitySessionCredentialsProvider build() {
            return new STSAssumeRoleWithWebIdentitySessionCredentialsProvider(this);
        }
    }
}

