/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.auth;

import com.amazonaws.auth.AWSCredentials;
import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.annotation.SdkInternalApi;
import com.simba.athena.amazonaws.auth.BasicAWSCredentials;
import com.simba.athena.amazonaws.auth.BasicSessionCredentials;
import com.simba.athena.amazonaws.util.DateUtils;
import com.simba.athena.amazonaws.util.json.Jackson;
import com.simba.athena.shaded.apache.commons.logging.Log;
import com.simba.athena.shaded.apache.commons.logging.LogFactory;
import com.simba.athena.shaded.fasterxml.jackson.databind.JsonNode;
import java.util.Date;

@SdkInternalApi
abstract class BaseCredentialsFetcher {
    private static final Log LOG = LogFactory.getLog(BaseCredentialsFetcher.class);
    private static final int REFRESH_THRESHOLD = 3600000;
    private static final int EXPIRATION_THRESHOLD = 900000;
    private static final String ACCESS_KEY_ID = "AccessKeyId";
    private static final String SECRET_ACCESS_KEY = "SecretAccessKey";
    private static final String TOKEN = "Token";
    private volatile AWSCredentials credentials;
    private volatile Date credentialsExpiration;
    protected volatile Date lastInstanceProfileCheck;

    BaseCredentialsFetcher() {
    }

    public AWSCredentials getCredentials() {
        if (this.needsToLoadCredentials()) {
            this.fetchCredentials();
        }
        if (this.expired()) {
            throw new SdkClientException("The credentials received have been expired");
        }
        return this.credentials;
    }

    boolean needsToLoadCredentials() {
        if (this.credentials == null) {
            return true;
        }
        if (this.credentialsExpiration != null && this.isWithinExpirationThreshold()) {
            return true;
        }
        return this.lastInstanceProfileCheck != null && this.isPastRefreshThreshold();
    }

    abstract String getCredentialsResponse();

    private synchronized void fetchCredentials() {
        if (!this.needsToLoadCredentials()) {
            return;
        }
        try {
            this.lastInstanceProfileCheck = new Date();
            String credentialsResponse = this.getCredentialsResponse();
            JsonNode node = Jackson.fromSensitiveJsonString(credentialsResponse, JsonNode.class);
            JsonNode accessKey = node.get(ACCESS_KEY_ID);
            JsonNode secretKey = node.get(SECRET_ACCESS_KEY);
            JsonNode token = node.get(TOKEN);
            if (null == accessKey || null == secretKey) {
                throw new SdkClientException("Unable to load credentials. Access key or secret key are null.");
            }
            this.credentials = null != token ? new BasicSessionCredentials(accessKey.asText(), secretKey.asText(), token.asText()) : new BasicAWSCredentials(accessKey.asText(), secretKey.asText());
            JsonNode expirationJsonNode = node.get("Expiration");
            if (null != expirationJsonNode) {
                String expiration = expirationJsonNode.asText();
                expiration = expiration.replaceAll("\\+0000$", "Z");
                try {
                    this.credentialsExpiration = DateUtils.parseISO8601Date(expiration);
                }
                catch (Exception ex) {
                    this.handleError("Unable to parse credentials expiration date from Amazon EC2 instance", ex);
                }
            }
        }
        catch (Exception e) {
            this.handleError("Unable to load credentials from service endpoint", e);
        }
    }

    private void handleError(String errorMessage, Exception e) {
        if (this.credentials == null || this.expired()) {
            if (e instanceof SdkClientException) {
                throw (SdkClientException)e;
            }
            throw new SdkClientException(errorMessage, e);
        }
        LOG.debug(errorMessage, e);
    }

    public void refresh() {
        this.credentials = null;
    }

    private boolean isWithinExpirationThreshold() {
        return this.credentialsExpiration.getTime() - System.currentTimeMillis() < 900000L;
    }

    private boolean isPastRefreshThreshold() {
        return System.currentTimeMillis() - this.lastInstanceProfileCheck.getTime() > 3600000L;
    }

    private boolean expired() {
        return this.credentialsExpiration != null && this.credentialsExpiration.getTime() < System.currentTimeMillis();
    }

    Date getCredentialsExpiration() {
        return this.credentialsExpiration;
    }

    public String toString() {
        return "BaseCredentialsFetcher";
    }
}

