/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hana.datatype;

import liquibase.Scope;
import liquibase.database.Database;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.core.CharType;
import liquibase.exception.DatabaseException;
import liquibase.ext.hana.HanaDatabase;

@DataTypeInfo(name="char", aliases={"java.sql.Types.CHAR", "bpchar"}, minParameters=0, maxParameters=1, priority=5)
public class CharTypeHana
extends CharType {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof HanaDatabase;
    }

    public DatabaseDataType toDatabaseDataType(Database database) {
        String typeString = "VARCHAR";
        try {
            if (database.getDatabaseMajorVersion() >= 4) {
                typeString = "NVARCHAR";
            }
        }
        catch (DatabaseException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Unable to determine the database version.", (Throwable)e);
        }
        Object[] parameters = this.getParameters();
        if (parameters.length > 0) {
            return new DatabaseDataType(typeString, new Object[]{parameters[0]});
        }
        return new DatabaseDataType(typeString);
    }
}

