/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.tasks;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTaskSettingsInput;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class DCCompareTaskSettings
implements DBTTaskSettingsInput<DBSDataContainer> {
    private static final Log log = Log.getLog(DCCompareTaskSettings.class);
    private DBSDataContainer leftContainer;
    private DBSDataContainer rightContainer;
    private DBSAttributeBase[] leftAttributes;
    private DBSAttributeBase[] rightAttributes;
    private long comparedRowsLimit = 0L;
    private long differentRowsLimit = 10000L;
    private int fetchSize = 10000;
    private boolean includeModifiedRows = true;
    private boolean includeDeletedRows = true;
    private boolean includeInsertedRows = true;

    public void loadConfiguration(@NotNull DBRRunnableContext runnableContext, @NotNull Map<String, Object> properties) {
        try {
            runnableContext.run(true, true, monitor -> {
                DBPProject project;
                if (!properties.containsKey("project")) {
                    return;
                }
                String projectName = CommonUtils.toString(properties.get("project"));
                DBPProject dBPProject = project = CommonUtils.isEmpty((String)projectName) ? null : DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
                if (project == null) {
                    log.error((Object)("Project '" + projectName + "' not found"));
                    return;
                }
                Map objectProperties = JSONUtils.getObject((Map)properties, (String)"first");
                this.leftContainer = this.loadContainer(monitor, project, objectProperties);
                this.leftAttributes = this.loadAttributes(monitor, (DBSEntity)this.leftContainer, objectProperties);
                objectProperties = JSONUtils.getObject((Map)properties, (String)"second");
                this.rightContainer = this.loadContainer(monitor, project, objectProperties);
                this.rightAttributes = this.loadAttributes(monitor, (DBSEntity)this.rightContainer, objectProperties);
                this.comparedRowsLimit = CommonUtils.toLong(properties.get("comparedRowsLimit"), (long)0L);
                this.differentRowsLimit = CommonUtils.toLong(properties.get("differentRowsLimit"), (long)10000L);
                this.fetchSize = CommonUtils.toInt(properties.get("fetchSize"), (int)10000);
                this.includeModifiedRows = CommonUtils.getBoolean(properties.get("includeModifiedRows"), (boolean)true);
                this.includeDeletedRows = CommonUtils.getBoolean(properties.get("includeDeletedRows"), (boolean)true);
                this.includeInsertedRows = CommonUtils.getBoolean(properties.get("includeInsertedRows"), (boolean)true);
            });
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getTargetException());
        }
        catch (InterruptedException e) {
            log.debug((Object)"Canceled by user", (Throwable)e);
        }
    }

    @Nullable
    private DBSDataContainer loadContainer(DBRProgressMonitor monitor, DBPProject project, Map<String, Object> properties) {
        String objectId = CommonUtils.toString((Object)properties.get("objectId"));
        monitor.beginTask("Load object '" + objectId + "'", 1);
        try {
            DBSDataContainer dBSDataContainer = (DBSDataContainer)DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)project, (String)objectId);
            return dBSDataContainer;
        }
        catch (DBException e) {
            log.error((Object)("Can't find object '" + objectId + "' in project '" + project.getName() + "'"), (Throwable)e);
            return null;
        }
        finally {
            monitor.done();
        }
    }

    @Nullable
    private DBSAttributeBase[] loadAttributes(DBRProgressMonitor monitor, DBSEntity entity, Map<String, Object> properties) {
        if (entity == null) {
            return null;
        }
        ArrayList<DBSEntityAttribute> attributes = new ArrayList<DBSEntityAttribute>();
        for (String column : JSONUtils.getStringList(properties, (String)"attributes")) {
            monitor.beginTask("Load attribute '" + column + "'", 1);
            try {
                DBSEntityAttribute attribute = entity.getAttribute(monitor, column);
                if (attribute == null) {
                    log.error((Object)("Can't find attribute '" + column + "'"));
                    return null;
                }
                try {
                    attributes.add(attribute);
                }
                catch (DBException e) {
                    log.error((Object)("Can't load attribute '" + column + "'"), (Throwable)e);
                    return null;
                }
            }
            finally {
                monitor.done();
            }
        }
        return attributes.toArray(new DBSAttributeBase[0]);
    }

    public void saveConfiguration(@NotNull Map<String, Object> state) {
        state.put("project", this.leftContainer.getDataSource().getContainer().getProject().getName());
        LinkedHashMap<String, Object> objectProperties = new LinkedHashMap<String, Object>();
        objectProperties.put("objectId", DBUtils.getObjectFullId((DBSObject)this.leftContainer));
        objectProperties.put("attributes", Arrays.stream(this.leftAttributes).map(DBPNamedObject::getName).collect(Collectors.toList()));
        state.put("first", objectProperties);
        objectProperties = new LinkedHashMap();
        objectProperties.put("objectId", DBUtils.getObjectFullId((DBSObject)this.rightContainer));
        objectProperties.put("attributes", Arrays.stream(this.rightAttributes).map(DBPNamedObject::getName).collect(Collectors.toList()));
        state.put("second", objectProperties);
        if (this.comparedRowsLimit != 0L) {
            state.put("comparedRowsLimit", this.comparedRowsLimit);
        }
        if (this.differentRowsLimit != 0L) {
            state.put("differentRowsLimit", this.differentRowsLimit);
        }
        if (this.fetchSize != 0) {
            state.put("fetchSize", this.fetchSize);
        }
        state.put("includeModifiedRows", this.includeModifiedRows);
        state.put("includeDeletedRows", this.includeDeletedRows);
        state.put("includeInsertedRows", this.includeInsertedRows);
    }

    public void loadSettingsFromInput(List<DBSDataContainer> objects) {
        if (objects.size() > 0) {
            this.leftContainer = objects.get(0);
        }
        if (objects.size() > 1) {
            this.rightContainer = objects.get(1);
        }
        if (objects.size() > 2) {
            log.warn((Object)("Too many containers: " + objects.size()));
        }
    }

    public DBSDataContainer getLeftContainer() {
        return this.leftContainer;
    }

    public void setLeftContainer(DBSDataContainer leftContainer) {
        this.leftContainer = leftContainer;
    }

    public DBSDataContainer getRightContainer() {
        return this.rightContainer;
    }

    public void setRightContainer(DBSDataContainer rightContainer) {
        this.rightContainer = rightContainer;
    }

    public DBSAttributeBase[] getLeftAttributes() {
        return this.leftAttributes;
    }

    public void setLeftAttributes(DBSAttributeBase[] leftAttributes) {
        this.leftAttributes = leftAttributes;
    }

    public DBSAttributeBase[] getRightAttributes() {
        return this.rightAttributes;
    }

    public void setRightAttributes(DBSAttributeBase[] rightAttributes) {
        this.rightAttributes = rightAttributes;
    }

    public long getComparedRowsLimit() {
        return this.comparedRowsLimit;
    }

    public void setComparedRowsLimit(long comparedRowsLimit) {
        this.comparedRowsLimit = comparedRowsLimit;
    }

    public long getDifferentRowsLimit() {
        return this.differentRowsLimit;
    }

    public void setDifferentRowsLimit(long differentRowsLimit) {
        this.differentRowsLimit = differentRowsLimit;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public boolean isIncludeModifiedRows() {
        return this.includeModifiedRows;
    }

    public void setIncludeModifiedRows(boolean includeModifiedRows) {
        this.includeModifiedRows = includeModifiedRows;
    }

    public boolean isIncludeDeletedRows() {
        return this.includeDeletedRows;
    }

    public void setIncludeDeletedRows(boolean includeDeletedRows) {
        this.includeDeletedRows = includeDeletedRows;
    }

    public boolean isIncludeInsertedRows() {
        return this.includeInsertedRows;
    }

    public void setIncludeInsertedRows(boolean includeInsertedRows) {
        this.includeInsertedRows = includeInsertedRows;
    }
}

