/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.tasks;

import com.dbeaver.data.compare.model.DCInput;
import com.dbeaver.data.compare.model.DCSettings;
import com.dbeaver.data.compare.model.DCSummary;
import com.dbeaver.data.compare.model.impl.DCCompareEngineImpl;
import com.dbeaver.data.compare.model.tasks.DCCompareTaskSettings;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskExecutionListener;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class DCCompareTaskHandler
implements DBTTaskHandler {
    public void executeTask(@NotNull DBRRunnableContext runnableContext, @NotNull DBTTask task, @NotNull Locale locale, @NotNull Log log, @NotNull PrintStream logStream, @NotNull DBTTaskExecutionListener listener) {
        DCCompareTaskSettings taskSettings = new DCCompareTaskSettings();
        taskSettings.loadConfiguration(runnableContext, task.getProperties());
        try {
            runnableContext.run(true, true, monitor -> {
                DBException error;
                DBSDataContainer leftContainer = taskSettings.getLeftContainer();
                DBSDataContainer rightContainer = taskSettings.getRightContainer();
                if (leftContainer == null || rightContainer == null) {
                    DBWorkbench.getPlatformUI().showError("Data Compare", "Containers are missing");
                    return;
                }
                DBSAttributeBase[] leftColumns = taskSettings.getLeftAttributes();
                DBSAttributeBase[] rightColumns = taskSettings.getRightAttributes();
                if (leftColumns == null || rightColumns == null) {
                    DBWorkbench.getPlatformUI().showError("Data Compare", "Constraint columns are missing");
                    return;
                }
                if (!(taskSettings.isIncludeModifiedRows() || taskSettings.isIncludeDeletedRows() || taskSettings.isIncludeInsertedRows())) {
                    DBWorkbench.getPlatformUI().showError("Data Compare", "At least one row state must be included");
                    return;
                }
                monitor.beginTask("Compare '" + DBUtils.getObjectFullName((DBPNamedObject)leftContainer, (DBPEvaluationContext)DBPEvaluationContext.UI) + "' <-> '" + DBUtils.getObjectFullName((DBPNamedObject)rightContainer, (DBPEvaluationContext)DBPEvaluationContext.UI) + "'", 1);
                Log.setLogWriter((OutputStream)logStream);
                listener.taskStarted((Object)task);
                try {
                    DCInput leftInput = this.createInput(leftContainer, leftColumns);
                    DCInput rightInput = this.createInput(rightContainer, rightColumns);
                    DCSettings settings = new DCSettings(leftInput, rightInput);
                    settings.setComparedRowsLimit(taskSettings.getComparedRowsLimit());
                    settings.setDifferentRowsLimit(taskSettings.getDifferentRowsLimit());
                    settings.setFetchSize(taskSettings.getFetchSize());
                    settings.setIncludeModifiedRows(taskSettings.isIncludeModifiedRows());
                    settings.setIncludeDeletedRows(taskSettings.isIncludeDeletedRows());
                    settings.setIncludeInsertedRows(taskSettings.isIncludeInsertedRows());
                    DCCompareEngineImpl engine = new DCCompareEngineImpl();
                    Throwable throwable = null;
                    Object var17_18 = null;
                    try (DCSummary summary = engine.compare(monitor, settings);){
                        log.debug((Object)"--- Data compare result ---");
                        log.debug((Object)(" - Compare Time: " + summary.getCompareTime() + "ms"));
                        log.debug((Object)(" - Inserted Rows Count: " + summary.getInsertedRowsCount()));
                        log.debug((Object)(" - Deleted Rows Count:  " + summary.getDeletedRowsCount()));
                        log.debug((Object)(" - Modified Rows Count: " + summary.getModifiedRowsCount()));
                        log.debug((Object)(" - Total Compared Rows Count:   " + summary.getTotalComparedRowsCount()));
                        log.debug((Object)(" - Total Different Rows Count:  " + summary.getTotalDifferentRowsCount()));
                        log.debug((Object)"--- Data compare result ---");
                        listener.taskFinished((Object)task, (Object)summary, null);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    monitor.worked(1);
                    return;
                }
                catch (DBException e) {
                    error = e;
                }
                finally {
                    monitor.done();
                    Log.setLogWriter(null);
                }
                listener.taskFinished((Object)task, null, (Throwable)error);
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Data Compare", "Error comparing data", e.getTargetException());
        }
        catch (InterruptedException e) {
            log.debug((Object)"Canceled by user", (Throwable)e);
        }
    }

    private DCInput createInput(DBSDataContainer container, DBSAttributeBase[] attributes) throws DBException {
        DCInput input = new DCInput(container, attributes);
        input.setFilter(this.createFilter(attributes));
        return input;
    }

    private DBDDataFilter createFilter(DBSAttributeBase[] attributes) {
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>();
        DBSAttributeBase[] dBSAttributeBaseArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSAttributeBase attribute = dBSAttributeBaseArray[n2];
            int position = constraints.size() + 1;
            DBDAttributeConstraint constraint = new DBDAttributeConstraint(attribute, position);
            constraint.setOrderPosition(position);
            constraints.add(constraint);
            ++n2;
        }
        return new DBDDataFilter(constraints);
    }
}

