/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.impl;

import com.dbeaver.data.compare.model.DCRowDiff;
import com.dbeaver.data.compare.model.DCSettings;
import com.dbeaver.data.compare.model.DCSummary;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jkiss.code.NotNull;

public class DCSummaryImpl
implements DCSummary {
    private final DCSettings settings;
    private final DCRowDiff[] differentRows;
    private long totalComparedRowsCount;
    private long insertedRowsCount;
    private long deletedRowsCount;
    private long modifiedRowsCount;
    private long compareTime;
    private boolean success;

    public DCSummaryImpl(@NotNull DCSettings settings, @NotNull DCRowDiff[] differentRows) {
        this.settings = settings;
        this.differentRows = differentRows;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Override
    public long getCompareTime() {
        return this.compareTime;
    }

    public void setCompareTime(long compareTime) {
        this.compareTime = compareTime;
    }

    @Override
    public long getInsertedRowsCount() {
        return this.insertedRowsCount;
    }

    public void setInsertedRowsCount(long insertedRowsCount) {
        this.insertedRowsCount = insertedRowsCount;
    }

    @Override
    public long getDeletedRowsCount() {
        return this.deletedRowsCount;
    }

    public void setDeletedRowsCount(long deletedRowsCount) {
        this.deletedRowsCount = deletedRowsCount;
    }

    @Override
    public long getModifiedRowsCount() {
        return this.modifiedRowsCount;
    }

    public void setModifiedRowsCount(long modifiedRowsCount) {
        this.modifiedRowsCount = modifiedRowsCount;
    }

    @Override
    public long getTotalComparedRowsCount() {
        return this.totalComparedRowsCount;
    }

    public void setTotalComparedRowsCount(long comparedRowsCount) {
        this.totalComparedRowsCount = comparedRowsCount;
    }

    @Override
    public long getTotalDifferentRowsCount() {
        return this.differentRows.length;
    }

    @Override
    @NotNull
    public DCSettings getSettings() {
        return this.settings;
    }

    @Override
    @NotNull
    public Iterator<DCRowDiff> iterator() {
        return new Iterator<DCRowDiff>(){
            private int offset = 0;

            @Override
            public boolean hasNext() {
                return this.offset < DCSummaryImpl.this.differentRows.length;
            }

            @Override
            public DCRowDiff next() {
                if (this.hasNext()) {
                    return DCSummaryImpl.this.differentRows[this.offset++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public void close() {
    }
}

