/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.impl;

import com.dbeaver.data.compare.model.DCCompareEngine;
import com.dbeaver.data.compare.model.DCInput;
import com.dbeaver.data.compare.model.DCRowDiff;
import com.dbeaver.data.compare.model.DCRowState;
import com.dbeaver.data.compare.model.DCSettings;
import com.dbeaver.data.compare.model.DCSummary;
import com.dbeaver.data.compare.model.impl.DCSummaryImpl;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Phaser;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DCCompareEngineImpl
implements DCCompareEngine {
    private static final Log log = Log.getLog(DCCompareEngineImpl.class);
    private Phaser phaser;
    private DataCompareReceiver leftReceiver;
    private DataCompareReceiver rightReceiver;
    private volatile boolean terminated;
    private List<DCRowDiff> diff;
    private long comparedRowsCount = 0L;
    private long insertedRowsCount = 0L;
    private long deletedRowsCount = 0L;
    private long modifiedRowsCount = 0L;

    @Override
    @NotNull
    public DCSummary compare(final @NotNull DBRProgressMonitor monitor, final @NotNull DCSettings settings) throws DBException {
        this.phaser = new Phaser(2){

            @Override
            protected boolean onAdvance(int phase, int registeredParties) {
                DCCompareEngineImpl.this.compareSegment(monitor, settings);
                return super.onAdvance(phase, registeredParties);
            }
        };
        this.leftReceiver = new DataCompareReceiver(monitor, settings, settings.getLeftInput());
        this.rightReceiver = new DataCompareReceiver(monitor, settings, settings.getRightInput());
        this.diff = new ArrayList<DCRowDiff>();
        long compareTimeStart = System.currentTimeMillis();
        this.leftReceiver.schedule();
        this.rightReceiver.schedule();
        while (!this.phaser.isTerminated()) {
            this.phaser.awaitAdvance(this.phaser.getPhase());
        }
        DCSummaryImpl summary = new DCSummaryImpl(settings, this.diff.toArray(new DCRowDiff[0]));
        summary.setSuccess(true);
        summary.setCompareTime(System.currentTimeMillis() - compareTimeStart);
        summary.setTotalComparedRowsCount(this.comparedRowsCount);
        summary.setInsertedRowsCount(this.insertedRowsCount);
        summary.setDeletedRowsCount(this.deletedRowsCount);
        summary.setModifiedRowsCount(this.modifiedRowsCount);
        return summary;
    }

    private void compareSegment(@NotNull DBRProgressMonitor monitor, @NotNull DCSettings settings) {
        DataCompareRow row;
        while (this.leftReceiver.available() && this.rightReceiver.available() && this.verifyLimits(monitor, settings)) {
            DataCompareRow rightRow;
            ++this.comparedRowsCount;
            DataCompareRow leftRow = this.leftReceiver.poll();
            int keys = leftRow.compareKeys(rightRow = this.rightReceiver.poll());
            if (keys != 0) {
                if (keys < 0) {
                    this.rightReceiver.push(rightRow);
                    if (!settings.isIncludeDeletedRows()) continue;
                    this.diff.add(new DCRowDiff(DCRowState.DELETED, leftRow.getKeyValues(), leftRow.position));
                    ++this.deletedRowsCount;
                    continue;
                }
                this.leftReceiver.push(leftRow);
                if (!settings.isIncludeInsertedRows()) continue;
                this.diff.add(new DCRowDiff(DCRowState.INSERTED, rightRow.getKeyValues(), rightRow.position));
                ++this.insertedRowsCount;
                continue;
            }
            int[] values = leftRow.compareValues(rightRow);
            if (values == null || !settings.isIncludeModifiedRows()) continue;
            this.diff.add(new DCRowDiff(DCRowState.MODIFIED, rightRow.getKeyValues(), values, rightRow.position));
            ++this.modifiedRowsCount;
        }
        while (this.leftReceiver.available() && this.verifyLimits(monitor, settings)) {
            ++this.comparedRowsCount;
            row = this.leftReceiver.poll();
            if (!settings.isIncludeDeletedRows()) continue;
            ++this.deletedRowsCount;
            this.diff.add(new DCRowDiff(DCRowState.DELETED, row.getKeyValues(), row.position));
        }
        while (this.rightReceiver.available() && this.verifyLimits(monitor, settings)) {
            ++this.comparedRowsCount;
            row = this.rightReceiver.poll();
            if (!settings.isIncludeInsertedRows()) continue;
            ++this.insertedRowsCount;
            this.diff.add(new DCRowDiff(DCRowState.INSERTED, row.getKeyValues(), row.position));
        }
        if (!this.verifyLimits(monitor, settings)) {
            this.terminated = true;
        }
    }

    private boolean verifyLimits(@NotNull DBRProgressMonitor monitor, @NotNull DCSettings settings) {
        long comparedRowsLimit = settings.getComparedRowsLimit();
        long differentRowsLimit = settings.getDifferentRowsLimit();
        if (comparedRowsLimit != 0L && comparedRowsLimit <= this.comparedRowsCount) {
            return false;
        }
        if (differentRowsLimit != 0L && differentRowsLimit <= (long)this.diff.size()) {
            return false;
        }
        return !monitor.isCanceled();
    }

    private static int[] getAttributesPositions(@NotNull DBRProgressMonitor monitor, @NotNull DCInput input) throws DBException {
        DBSAttributeBase[] attributes = input.getAttributes();
        DBSEntity entity = (DBSEntity)input.getContainer();
        int[] positions = new int[attributes.length];
        int index = 0;
        while (index < attributes.length) {
            positions[index] = DCCompareEngineImpl.getAttributePosition(monitor, entity, attributes[index]);
            ++index;
        }
        return positions;
    }

    private static int getAttributePosition(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity, @NotNull DBSAttributeBase attribute) throws DBException {
        return CommonUtils.safeList((List)entity.getAttributes(monitor)).stream().map(x -> x).filter(x -> !DBUtils.isPseudoAttribute((DBSAttributeBase)x) && !DBUtils.isHiddenObject((Object)x)).collect(Collectors.toList()).indexOf(attribute);
    }

    private class DataCompareReceiver
    extends AbstractJob
    implements DBDDataReceiver {
        private final DCSettings settings;
        private final DCInput input;
        private final Deque<DataCompareRow> rows;
        private final int[] keys;
        private DBDAttributeBinding[] bindings;
        private long offset;

        private DataCompareReceiver(@NotNull DBRProgressMonitor monitor, @NotNull DCSettings settings, DCInput input) throws DBException {
            super("Data Compare Receiver [" + DBUtils.getObjectFullName((DBPNamedObject)input.getContainer(), (DBPEvaluationContext)DBPEvaluationContext.UI) + "]");
            this.settings = settings;
            this.input = input;
            this.rows = new ArrayDeque<DataCompareRow>();
            this.keys = DCCompareEngineImpl.getAttributesPositions(monitor, input);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            DBSDataContainer container = this.input.getContainer();
            DBDDataFilter filter = this.input.getFilter();
            monitor.beginTask("Read data to compare", 1);
            try {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (DBCSession session = DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Read data");){
                        AbstractExecutionSource source = new AbstractExecutionSource(container, null, (Object)this);
                        container.readData((DBCExecutionSource)source, session, (DBDDataReceiver)this, filter, 0L, 0L, 0L, 0);
                        monitor.worked(1);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (DataCompareTerminationException dataCompareTerminationException) {
                    monitor.done();
                }
                catch (Throwable e) {
                    DCCompareEngineImpl.this.phaser.forceTermination();
                    IStatus iStatus = GeneralUtils.makeErrorStatus((String)"Error reading data", (Throwable)e);
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        public void fetchStart(DBCSession session, DBCResultSet resultSet, long offset, long maxRows) throws DBCException {
            this.bindings = DBUtils.getAttributeBindings((DBCSession)session, (DBSDataContainer)this.input.getContainer(), (DBCResultSetMetaData)resultSet.getMeta());
            this.offset = offset;
        }

        public void fetchRow(DBCSession session, DBCResultSet resultSet) throws DBCException {
            if (this.settings.getFetchSize() != 0 && this.settings.getFetchSize() <= this.rows.size()) {
                log.trace((Object)(String.valueOf(this.getName()) + ": Segment is ready (" + this.rows.size() + ")"));
                DCCompareEngineImpl.this.phaser.arriveAndAwaitAdvance();
            }
            if (this.isCanceled() || DCCompareEngineImpl.this.terminated) {
                throw new DataCompareTerminationException("Fetch was terminated");
            }
            Object[] values = new Object[this.bindings.length];
            int index = 0;
            while (index < this.bindings.length) {
                values[index] = resultSet.getAttributeValue(index);
                ++index;
            }
            this.rows.add(new DataCompareRow(this.offset, values, this.keys));
            ++this.offset;
        }

        public void fetchEnd(DBCSession session, DBCResultSet resultSet) {
            log.trace((Object)(String.valueOf(this.getName()) + ": Terminated, sending last segment (" + this.rows.size() + ")"));
            DCCompareEngineImpl.this.phaser.arriveAndDeregister();
        }

        public void close() {
        }

        public boolean available() {
            return !this.rows.isEmpty();
        }

        @NotNull
        public DataCompareRow poll() {
            return this.rows.removeFirst();
        }

        public void push(@NotNull DataCompareRow row) {
            this.rows.offerFirst(row);
        }
    }

    private static class DataCompareRow {
        private final long position;
        private final Object[] values;
        private final int[] keys;

        public DataCompareRow(long position, @NotNull Object[] values, @NotNull int[] keys) {
            this.position = position;
            this.values = values;
            this.keys = keys;
        }

        public int compareKeys(@NotNull DataCompareRow other) {
            int index = 0;
            while (index < this.keys.length) {
                Object value = this.values[this.keys[index]];
                Object otherValue = other.values[other.keys[index]];
                int result = DBUtils.compareDataValues((Object)value, (Object)otherValue);
                if (result != 0) {
                    return result;
                }
                ++index;
            }
            return 0;
        }

        @Nullable
        public int[] compareValues(@NotNull DataCompareRow other) {
            int[] indexes = IntStream.range(0, Math.min(this.values.length, other.values.length)).filter(x -> !Objects.equals(this.values[x], dataCompareRow.values[x])).toArray();
            if (indexes.length == 0) {
                return null;
            }
            return indexes;
        }

        @NotNull
        public int[] missingValues(@NotNull DataCompareRow other) {
            return IntStream.range(Math.min(this.values.length, other.values.length), Math.max(this.values.length, other.values.length)).toArray();
        }

        public long getPosition() {
            return this.position;
        }

        public Object[] getValues() {
            return this.values;
        }

        public int[] getKeys() {
            return this.keys;
        }

        @NotNull
        public Object[] getKeyValues() {
            return IntStream.of(this.keys).mapToObj(index -> this.values[index]).toArray();
        }
    }

    private static class DataCompareTerminationException
    extends DBCException {
        public DataCompareTerminationException(String message) {
            super(message);
        }
    }
}

