/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model;

import com.dbeaver.data.compare.model.DCRowState;
import java.util.Arrays;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class DCRowDiff {
    private final DCRowState state;
    private final Object[] keys;
    private final int[] columns;
    private final long position;

    public DCRowDiff(@NotNull DCRowState state, @NotNull Object[] keys, @NotNull int[] columns, long position) {
        this.state = state;
        this.keys = keys;
        this.columns = columns;
        this.position = position;
    }

    public DCRowDiff(@NotNull DCRowState state, @NotNull Object[] keys, long position) {
        this.state = state;
        this.keys = keys;
        this.columns = null;
        this.position = position;
    }

    @NotNull
    public DCRowState getState() {
        return this.state;
    }

    @NotNull
    public Object[] getKeys() {
        return this.keys;
    }

    @Nullable
    public int[] getColumns() {
        return this.columns;
    }

    public long getPosition() {
        return this.position;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DCRowDiff diff = (DCRowDiff)o;
        return this.position == diff.position && this.state == diff.state && Arrays.equals(this.keys, diff.keys) && Arrays.equals(this.columns, diff.columns);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.state, this.position});
        result = 31 * result + Arrays.hashCode(this.keys);
        result = 31 * result + Arrays.hashCode(this.columns);
        return result;
    }

    public String toString() {
        return "DCRowDiff{state=" + (Object)((Object)this.state) + ", keys=" + Arrays.toString(this.keys) + ", columns=" + Arrays.toString(this.columns) + ", position=" + this.position + '}';
    }
}

