/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.views;

import com.dbeaver.db.mongodb.MongoDBMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.net.SSLConfiguratorTrustStoreUI;

public class MongoSSLConfigurator
extends SSLConfiguratorTrustStoreUI {
    private Button allowInvalidHostName;
    private Button useSelfSignedCertificate;

    public void createControl(final Composite parent, Runnable propertyChangeListener) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gd = new GridData(1808);
        gd.minimumHeight = 200;
        composite.setLayoutData((Object)gd);
        this.createSSLConfigHint(composite, true, 1);
        this.createTrustStoreConfigGroup(composite);
        Group certGroup = UIUtils.createControlGroup((Composite)composite, (String)MongoDBMessages.connection_page_ssl_legend_settings, (int)1, (int)768, (int)-1);
        this.allowInvalidHostName = UIUtils.createCheckbox((Composite)certGroup, (String)MongoDBMessages.connection_page_ssl_settings_checkbox_skip_hostname_validation, (String)"", (boolean)false, (int)1);
        this.useSelfSignedCertificate = UIUtils.createCheckbox((Composite)certGroup, (String)MongoDBMessages.connection_page_ssl_settings_checkbox_use_self_signed_certificate, (String)"", (boolean)false, (int)1);
        this.useSelfSignedCertificate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MongoSSLConfigurator.this.useSelfSignedCertificate.getSelection() && !UIUtils.confirmAction((Shell)parent.getShell(), (String)MongoDBMessages.connection_page_ssl_settings_checkbox_use_self_signed_certificate_title, (String)MongoDBMessages.connection_page_ssl_settings_checkbox_use_self_signed_certificate_text, (int)8)) {
                    MongoSSLConfigurator.this.useSelfSignedCertificate.setSelection(false);
                }
            }
        });
    }

    protected boolean useCACertificate() {
        return true;
    }

    public void loadSettings(DBWHandlerConfiguration configuration) {
        super.loadSettings(configuration);
        this.allowInvalidHostName.setSelection(configuration.getBooleanProperty("sslInvalidHostNameAllowed"));
        this.useSelfSignedCertificate.setSelection(configuration.getBooleanProperty("ssl.self-signed-cert"));
    }

    public void saveSettings(DBWHandlerConfiguration configuration) {
        super.saveSettings(configuration);
        configuration.setProperty("sslInvalidHostNameAllowed", (Object)this.allowInvalidHostName.getSelection());
        configuration.setProperty("ssl.self-signed-cert", (Object)this.useSelfSignedCertificate.getSelection());
    }
}

