/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.views;

import com.dbeaver.db.mongodb.MongoDBMessages;
import com.dbeaver.db.mongodb.MongoUIActivator;
import com.dbeaver.db.mongodb.views.MongoConnectionPageBase;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class AWSDocumentDBConnectionPage
extends MongoConnectionPageBase {
    private static final ImageDescriptor logoImage = MongoUIActivator.getImageDescriptor("icons/amazon_documentdb_logo.png");
    private Text userNameText;

    @Override
    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        super.createControl(composite);
    }

    @Override
    protected void createAuthPanel(Composite settingsGroup) {
        Group authGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)MongoDBMessages.connection_page_group_credentials, (int)4, (int)768, (int)-1);
        this.userNameText = UIUtils.createLabelText((Composite)authGroup, (String)MongoDBMessages.connection_page_label_text_user, (String)"", (int)2048);
        this.createPasswordText((Composite)authGroup, MongoDBMessages.connection_page_label_text_password);
        this.createPasswordControls((Composite)authGroup, 2);
    }

    @Override
    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
            this.userNameText.setText(connectionInfo.getUserName());
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserPassword())) {
            this.passwordText.setText(connectionInfo.getUserPassword());
        }
    }

    @Override
    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        connectionInfo.setUserName(this.userNameText.getText().trim());
        connectionInfo.setUserPassword(this.passwordText.getText());
        super.saveSettings(dataSource);
    }
}

