/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public final class RuntimeUtils {
    private static final Log log = Log.getLog(RuntimeUtils.class);
    private static final boolean IS_WINDOWS = Platform.getOS().equals("win32");
    private static final boolean IS_MACOS = Platform.getOS().equals("macosx");
    private static final boolean IS_LINUX = Platform.getOS().equals("linux");

    private RuntimeUtils() {
    }

    public static <T> T getObjectAdapter(Object adapter, Class<T> objectType) {
        return (T)Platform.getAdapterManager().getAdapter(adapter, objectType);
    }

    public static DBRProgressMonitor makeMonitor(IProgressMonitor monitor) {
        if (monitor instanceof DBRProgressMonitor) {
            return (DBRProgressMonitor)monitor;
        }
        return new DefaultProgressMonitor(monitor);
    }

    public static IProgressMonitor getNestedMonitor(DBRProgressMonitor monitor) {
        if (monitor instanceof IProgressMonitor) {
            return (IProgressMonitor)monitor;
        }
        return monitor.getNestedMonitor();
    }

    public static File getUserHomeDir() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            userHome = ".";
        }
        return new File(userHome);
    }

    public static String getCurrentDate() {
        return new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH).format(new Date());
    }

    public static String getCurrentTimeStamp() {
        return new SimpleDateFormat("yyyyMMddHHmm", Locale.ENGLISH).format(new Date());
    }

    public static boolean isTypeSupported(Class<?> type, Class[] supportedTypes) {
        if (type == null || ArrayUtils.isEmpty((Object[])supportedTypes)) {
            return false;
        }
        Class[] classArray = supportedTypes;
        int n = supportedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class tmp = classArray[n2];
            if (tmp.isAssignableFrom(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getNativeBinaryName(String binName) {
        return RuntimeUtils.isWindows() ? String.valueOf(binName) + ".exe" : binName;
    }

    public static File getNativeClientBinary(@NotNull DBPNativeClientLocation home, @Nullable String binFolder, @NotNull String binName) throws IOException {
        binName = RuntimeUtils.getNativeBinaryName(binName);
        File dumpBinary = new File(home.getPath(), binFolder == null ? binName : String.valueOf(binFolder) + "/" + binName);
        if (!dumpBinary.exists() && !(dumpBinary = new File(home.getPath(), binName)).exists()) {
            throw new IOException("Utility '" + binName + "' not found in client home '" + home.getDisplayName() + "' (" + home.getPath().getAbsolutePath() + ")");
        }
        return dumpBinary;
    }

    @NotNull
    public static IStatus stripStack(@NotNull IStatus status) {
        if (status instanceof MultiStatus) {
            IStatus[] children = status.getChildren();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    children[i] = RuntimeUtils.stripStack(children[i]);
                    ++i;
                }
            }
            return new MultiStatus(status.getPlugin(), status.getCode(), children, status.getMessage(), null);
        }
        if (status instanceof Status) {
            String messagePrefix = "";
            if (status.getException() != null && CommonUtils.isEmpty((String)status.getException().getMessage())) {
                messagePrefix = String.valueOf(status.getException().getClass().getName()) + ": ";
                return new Status(status.getSeverity(), status.getPlugin(), status.getCode(), String.valueOf(messagePrefix) + status.getMessage(), null);
            }
            return status;
        }
        return status;
    }

    public static void pause(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            log.debug("Sleep interrupted", e);
        }
    }

    public static String formatExecutionTime(long ms) {
        if (ms < 1000L) {
            return String.valueOf(String.valueOf(ms)) + "ms";
        }
        if (ms < 60000L) {
            return String.valueOf(String.valueOf(ms / 1000L)) + "." + String.valueOf(ms % 1000L) + "s";
        }
        long sec = ms / 1000L;
        long min = sec / 60L;
        return String.valueOf(String.valueOf(min)) + "m " + String.valueOf(sec -= min * 60L) + "s";
    }

    public static File getPlatformFile(String platformURL) throws IOException {
        URL url = new URL(platformURL);
        URL fileURL = FileLocator.toFileURL((URL)url);
        return RuntimeUtils.getLocalFileFromURL(fileURL);
    }

    public static File getLocalFileFromURL(URL fileURL) throws IOException {
        try {
            URI filePath = GeneralUtils.makeURIFromFilePath(fileURL.toString());
            return new File(filePath);
        }
        catch (URISyntaxException e) {
            throw new IOException("Bad local file path: " + fileURL, e);
        }
    }

    public static boolean runTask(DBRRunnableWithProgress task, String taskName, long waitTime) {
        return RuntimeUtils.runTask(task, taskName, waitTime, false);
    }

    public static boolean runTask(DBRRunnableWithProgress task, String taskName, long waitTime, boolean hidden) {
        final MonitoringTask monitoringTask = new MonitoringTask(task);
        AbstractJob monitorJob = new AbstractJob(taskName, hidden){
            {
                super($anonymous0);
                this.setSystem(bl);
                this.setUser(!bl);
            }

            @Override
            protected IStatus run(DBRProgressMonitor monitor) {
                monitor.beginTask(this.getName(), 1);
                try {
                    try {
                        monitor.subTask("Execute task");
                        monitoringTask.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        log.error(String.valueOf(this.getName()) + " - error", e.getTargetException());
                        IStatus iStatus = Status.OK_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                    catch (InterruptedException interruptedException) {
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        monitorJob.schedule();
        long startTime = System.currentTimeMillis();
        while (!monitoringTask.finished) {
            if (waitTime > 0L && System.currentTimeMillis() - startTime > waitTime) break;
            try {
                if (DBWorkbench.getPlatformUI().readAndDispatchEvents()) continue;
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                log.debug("Task '" + taskName + "' was interrupted");
                break;
            }
        }
        return monitoringTask.finished;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String executeProcess(String binPath, String ... args) throws DBException {
        try {
            Object[] cmdBin = new String[]{binPath};
            Object[] cmd = args == null ? cmdBin : (String[])ArrayUtils.concatArrays((Object[])cmdBin, (Object[])args);
            Process p = Runtime.getRuntime().exec((String[])cmd);
            try {
                StringBuilder out = new StringBuilder();
                RuntimeUtils.readStringToBuffer(p.getInputStream(), out);
                if (out.length() == 0) {
                    StringBuilder err = new StringBuilder();
                    RuntimeUtils.readStringToBuffer(p.getErrorStream(), err);
                    String string = err.toString();
                    return string;
                }
                String string = out.length() == 0 ? null : out.toString();
                return string;
            }
            finally {
                p.destroy();
            }
        }
        catch (Exception ex) {
            throw new DBException("Error executing process " + binPath, ex);
        }
    }

    private static void readStringToBuffer(InputStream is, StringBuilder out) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader input = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = input.readLine()) != null) {
                if (out.length() > 0) {
                    out.append("\n");
                }
                out.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isMacOS() {
        return IS_MACOS;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    public static void setThreadName(String name) {
        Thread.currentThread().setName("DBeaver: " + name);
    }

    private static class MonitoringTask
    implements DBRRunnableWithProgress {
        private final DBRRunnableWithProgress task;
        private DBRProgressMonitor monitor;
        volatile boolean finished;

        private MonitoringTask(DBRRunnableWithProgress task) {
            this.task = task;
        }

        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.monitor = monitor;
            try {
                this.task.run(monitor);
            }
            finally {
                this.finished = true;
            }
        }
    }
}

