/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.model;

import com.dbeaver.db.mongodb.MongoUtils;
import com.dbeaver.db.mongodb.exec.MongoExecutionContext;
import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.model.MGDataSourceInfo;
import com.dbeaver.db.mongodb.model.MGDataType;
import com.dbeaver.db.mongodb.model.MGDatabase;
import com.dbeaver.db.mongodb.model.MGOperationManager;
import com.dbeaver.db.mongodb.model.MGSQLDialect;
import com.dbeaver.db.mongodb.model.MGTypeConverters;
import com.dbeaver.ee.model.NoSQLDataSource;
import com.dbeaver.ee.model.document.DocumentDataManager;
import com.dbeaver.ee.model.document.data.DBMapValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.MongoSocketException;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;
import org.osgi.framework.Version;

public abstract class MGDataSource
extends NoSQLDataSource<MongoExecutionContext>
implements DBPDataSource,
DocumentDataManager<MGDataSource, Map<String, Object>>,
DBPRefreshableObject,
DBPObjectStatisticsCollector,
DBPTermProvider,
DBPDataTypeProvider,
DBPErrorAssistant,
IAdaptable {
    private static final Log log = Log.getLog(MGDataSource.class);
    private final Gson JSON_BUILDER;
    private Version serverVersion;
    private DatabaseCache databaseCache = new DatabaseCache();
    private MGDataSourceInfo info;
    private List<MGDataType> dataTypes = new ArrayList<MGDataType>();
    private boolean hasStatistics;

    protected MGDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(container);
        DBPConnectionConfiguration connectionInfo = this.getContainer().getConnectionConfiguration();
        this.dataTypes.add(new MGDataType(this, 1, "ObjectId", "objectId"));
        this.dataTypes.add(new MGDataType(this, 2, "Document", "document"));
        this.dataTypes.add(new MGDataType(this, 3, "String", "string"));
        this.dataTypes.add(new MGDataType(this, 4, "Number", "number"));
        this.dataTypes.add(new MGDataType(this, 7, "Boolean", "boolean"));
        this.dataTypes.add(new MGDataType(this, 8, "Timestamp", "date"));
        this.dataTypes.add(new MGDataType(this, 9, "Binary", "byte[]"));
        this.dataTypes.add(new MGDataType(this, 10, "List", "array"));
        this.dataTypes.add(new MGDataType(this, 11, "Object", "object"));
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ObjectId.class, (Object)new MGTypeConverters.ObjectIdTypeConverter()).registerTypeAdapter(Date.class, (Object)new MGTypeConverters.ISODateTypeConverter()).registerTypeAdapter(BsonTimestamp.class, (Object)new MGTypeConverters.BsonTimestampConverter()).setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").serializeNulls();
        if (this.supportsDecimal128()) {
            gsonBuilder.registerTypeAdapter(Decimal128.class, (Object)new MGTypeConverters.Decimal128TypeConverter());
        }
        this.JSON_BUILDER = gsonBuilder.create();
        this.executionContext = new MongoExecutionContext(this, "Main " + this.getDatabaseType() + " Connection", connectionInfo.getDatabaseName());
        ((MongoExecutionContext)this.executionContext).connect(monitor);
        Document buildInfo = ((MongoExecutionContext)this.executionContext).getBuildInfo();
        Object version = buildInfo.get((Object)"version");
        if (version != null) {
            try {
                this.serverVersion = new Version(CommonUtils.toString((Object)version).replaceAll("[^\\d.]", ""));
            }
            catch (Exception e) {
                log.debug((Object)("Can't extract " + this.getDatabaseType() + " server version"), (Throwable)e);
            }
        }
    }

    public Version getServerVersion() {
        return this.serverVersion;
    }

    public boolean isServerVersionAtLeast(int major, int minor) {
        if (this.serverVersion == null) {
            return true;
        }
        if (this.serverVersion.getMajor() < major) {
            return false;
        }
        return this.serverVersion.getMajor() != major || this.serverVersion.getMinor() >= minor;
    }

    public MongoExecutionContext getExecutionContext() {
        return (MongoExecutionContext)this.executionContext;
    }

    public DatabaseCache getDatabaseCache() {
        return this.databaseCache;
    }

    @NotNull
    public MongoDatabase getAdminDatabase(MongoSession session) throws DBCException {
        return session.getExecutionContext().getClient().getDatabase("admin");
    }

    @NotNull
    public DB getAdminDB(MongoSession session) throws DBCException {
        return session.getExecutionContext().getClient().getDB("admin");
    }

    @Association
    public Collection<MGDatabase> getDatabases() {
        return this.databaseCache.getCachedObjects();
    }

    public MGDatabase getDatabase(String name) {
        return (MGDatabase)this.databaseCache.getCachedObject(name);
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    @NotNull
    public MongoExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        MongoExecutionContext context = new MongoExecutionContext(this, purpose, initFrom instanceof MongoExecutionContext ? ((MongoExecutionContext)initFrom).getSelectedDatabase() : this.getDefaultDatabase());
        context.connect(monitor);
        return context;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        try {
            this.databaseCache.getAllObjects(monitor, this);
            this.info = new MGDataSourceInfo(this, ((MongoExecutionContext)this.executionContext).getClient());
        }
        catch (Exception e) {
            throw new DBException("Error initializing " + this.getDatabaseType() + " context", (Throwable)e);
        }
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.databaseCache.clearCache();
        this.hasStatistics = false;
        this.initialize(monitor);
        return this;
    }

    public String getDefaultDatabase() {
        return ((MongoExecutionContext)this.executionContext).getSelectedDatabase();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return null;
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new MGOperationManager(this));
        }
        return null;
    }

    public String getObjectTypeTerm(String path, String objectType, boolean multiple) {
        String term = null;
        if ("cluster".equals(objectType)) {
            term = "Cluster";
        } else if ("keypace".equals(objectType)) {
            term = "Keyspace";
        }
        if (term != null && multiple) {
            term = String.valueOf(term) + "s";
        }
        return term;
    }

    public MGSQLDialect getSQLDialect() {
        return MGSQLDialect.INSTANCE;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getDatabases();
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getDatabase(childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return MGDatabase.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        switch (typeID) {
            case 1: {
                return DBPDataKind.STRING;
            }
            case 2: {
                return DBPDataKind.DOCUMENT;
            }
            case 3: {
                return DBPDataKind.STRING;
            }
            case 4: {
                return DBPDataKind.NUMERIC;
            }
            case 7: {
                return DBPDataKind.BOOLEAN;
            }
            case 8: {
                return DBPDataKind.DATETIME;
            }
            case 9: {
                return DBPDataKind.BINARY;
            }
            case 10: {
                return DBPDataKind.ARRAY;
            }
        }
        return DBPDataKind.ANY;
    }

    public MGDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        MGDataType dataType = this.getLocalDataType(typeFullName);
        if (dataType == null || dataType.getTypeID() == 2) {
            return null;
        }
        return dataType;
    }

    public Collection<MGDataType> getLocalDataTypes() {
        return this.dataTypes;
    }

    public MGDataType getLocalDataType(String typeName) {
        for (MGDataType type : this.dataTypes) {
            if (!type.getName().equals(typeName)) continue;
            return type;
        }
        return null;
    }

    public MGDataType getLocalDataType(int typeID) {
        for (MGDataType type : this.dataTypes) {
            if (type.getTypeID() != typeID) continue;
            return type;
        }
        return null;
    }

    public MGDataType getDataTypeByJS(String typeName) {
        for (MGDataType type : this.dataTypes) {
            if (!type.getJsName().equals(typeName)) continue;
            return type;
        }
        return this.getDocumentDataType(11);
    }

    public boolean supportsDecimal128() {
        return true;
    }

    public MGDataType getDocumentDataType(int valueType) {
        return this.getLocalDataType(valueType);
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return "String";
    }

    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        if (error.getCause() instanceof MongoSocketException) {
            return DBPErrorAssistant.ErrorType.CONNECTION_LOST;
        }
        return DBPErrorAssistant.ErrorType.NORMAL;
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        return null;
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        this.hasStatistics = true;
        for (MGDatabase db : this.getDatabases()) {
            try {
                db.readStatistics(monitor);
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
        }
    }

    public void serializeDocument(Map<String, Object> document, Writer writer) {
        this.JSON_BUILDER.toJson(MongoUtils.unwrapMongoValue(null, document), (Appendable)writer);
    }

    public Map<String, Object> deserializeDocument(Reader reader) {
        StringWriter buf = new StringWriter();
        try {
            IOUtils.copyText((Reader)reader, (Writer)buf);
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
        String json = buf.toString();
        return BasicDBObject.parse((String)json);
    }

    public DBMapValue<MGDataSource> convertNativeDocumentToMap(Map<String, Object> dbObject) {
        return (DBMapValue)MongoUtils.wrapMongoValue(this, dbObject, null);
    }

    public Map<String, Object> convertMapToNativeDocument(DBMapValue<MGDataSource> map) {
        return (Map)MongoUtils.unwrapMongoValue(null, (Object)map.getRawValue());
    }

    public DBWHandlerConfiguration getCustomSSLConfiguration(DBRProgressMonitor monitor, DBPConnectionConfiguration connectionInfo) {
        return null;
    }

    public String getDefaultAuthMachanism() {
        return "NONE";
    }

    public abstract boolean isEvalSupported();

    public abstract String getDatabaseType();

    class DatabaseCache
    extends BasicObjectCache<MGDataSource, MGDatabase> {
        DatabaseCache() {
        }

        @NotNull
        public List<MGDatabase> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable MGDataSource dataSource) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<MGDatabase> databaseList = new ArrayList<MGDatabase>();
                DBPConnectionConfiguration configuration = MGDataSource.this.getContainer().getActualConnectionConfiguration();
                if (!CommonUtils.getBoolean((String)configuration.getProviderProperty("showAllDatabases"), (boolean)true) && !CommonUtils.isEmpty((String)configuration.getDatabaseName())) {
                    databaseList.add(new MGDatabase(dataSource, configuration.getDatabaseName()));
                } else {
                    try {
                        Throwable throwable = null;
                        Object var6_7 = null;
                        try (MongoSession session = (MongoSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)MGDataSource.this, (String)"Read databases");){
                            MongoIterable databaseNames = session.getExecutionContext().getClient().listDatabaseNames();
                            for (String dbName : databaseNames) {
                                MGDatabase db = new MGDatabase(dataSource, dbName);
                                databaseList.add(db);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {
                        assert (dataSource != null);
                        databaseList.add(new MGDatabase(dataSource, dataSource.getContainer().getConnectionConfiguration().getDatabaseName()));
                    }
                }
                this.setCache(databaseList);
            }
            return this.getCachedObjects();
        }
    }
}

