/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec;

import com.dbeaver.db.mongodb.exec.MongoCustomStatement;
import com.dbeaver.db.mongodb.exec.MongoEvalStatement;
import com.dbeaver.db.mongodb.exec.MongoExecutionContext;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.ee.model.NoSQLConstants;
import com.mongodb.client.ClientSession;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.AbstractSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class MongoSession
extends AbstractSession {
    private final MongoExecutionContext executionContext;

    public MongoSession(DBRProgressMonitor monitor, DBCExecutionPurpose purpose, String taskTitle, MongoExecutionContext executionContext) {
        super(monitor, purpose, taskTitle);
        this.executionContext = executionContext;
    }

    @NotNull
    public MongoExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public MGDataSource getDataSource() {
        return (MGDataSource)this.executionContext.getDataSource();
    }

    @Nullable
    public ClientSession getClientSession() {
        return this.executionContext.getClientSession();
    }

    @NotNull
    public DBCStatement prepareStatement(@NotNull DBCStatementType type, @NotNull String query, boolean scrollable, boolean updatable, boolean returnGeneratedKeys) throws DBCException {
        if (NoSQLConstants.SQL_PATTERN.matcher(query).matches()) {
            return new MongoCustomStatement(this, query);
        }
        return new MongoEvalStatement(this, query);
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread != null) {
            blockThread.interrupt();
        }
    }

    public void close() {
        super.close();
    }
}

