/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec;

import com.dbeaver.db.mongodb.exec.MongoResultSet;
import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.dbeaver.ee.model.document.exec.DocumentReadStatement;
import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteResult;
import com.mongodb.client.MongoIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public abstract class MongoBaseStatement
extends DocumentReadStatement<MongoSession> {
    private final String query;
    protected MGCollection collection;
    protected DBCursor result;
    protected MongoIterable iterableResult;
    protected List<DBObject> resultList;
    protected WriteResult writeResult;
    private Throwable executeError;
    protected long offset;
    protected long limit;
    private int fetchSize;

    MongoBaseStatement(MongoSession session, String query) {
        super((DBCSession)session);
        this.query = query;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    public String getQueryString() {
        return this.query;
    }

    public void addToBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public MongoResultSet openResultSet() throws DBCException {
        if (this.resultList != null) {
            return new MongoResultSet(this, this.resultList);
        }
        if (this.result != null) {
            return new MongoResultSet(this, this.result);
        }
        if (this.iterableResult != null) {
            return new MongoResultSet(this, this.iterableResult.cursor());
        }
        return null;
    }

    public boolean hasResultSet() {
        return this.resultList != null || this.result != null || this.iterableResult != null;
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int getUpdateRowCount() {
        return this.writeResult == null ? -1 : this.writeResult.getN();
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public void close() {
        this.result = null;
        this.iterableResult = null;
        this.resultList = null;
        if (((MongoSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, (long)this.getUpdateRowCount());
        }
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public int getResultsFetchSize() {
        return this.fetchSize;
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
        this.fetchSize = fetchSize;
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread == null) {
            throw new DBException("Mongo query cancel not implemented");
        }
        blockThread.interrupt();
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    protected DBCException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (ex instanceof DBCException) {
            return (DBCException)ex;
        }
        return new DBCException(ex, (DBCExecutionContext)((MongoSession)this.getSession()).getExecutionContext());
    }

    protected void beforeExecute() {
        this.executeError = null;
        if (((MongoSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock();
    }

    protected void afterExecute() {
        this.endBlock();
        if (((MongoSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, (long)this.getUpdateRowCount(), this.executeError);
        }
    }

    protected void startBlock() {
        ((MongoSession)this.getSession()).getProgressMonitor().startBlock((DBRBlockingObject)this, null);
    }

    protected void endBlock() {
        ((MongoSession)this.getSession()).getProgressMonitor().endBlock();
    }

    protected void setExecutionResult(CommandResult commandResult) {
        Object retval = commandResult.get("retval");
        if (retval instanceof DBCursor) {
            this.result = (DBCursor)retval;
        } else if (retval instanceof MongoIterable) {
            this.iterableResult = (MongoIterable)retval;
        } else {
            this.resultList = new ArrayList<DBObject>(1);
            if (retval == null) {
                this.resultList.add((DBObject)commandResult);
            } else if (retval instanceof Collection) {
                boolean objects = true;
                for (Object obj : (Collection)retval) {
                    if (obj instanceof DBObject) continue;
                    objects = false;
                    break;
                }
                if (objects) {
                    this.resultList.addAll((Collection)retval);
                } else {
                    this.resultList.add((DBObject)retval);
                }
            } else if (retval instanceof DBObject) {
                this.resultList.add((DBObject)retval);
            } else {
                this.resultList.add((DBObject)new BasicDBObject("retval", retval));
            }
        }
    }

    protected void setExecutionResult(Object retval) {
        if (retval instanceof DBCursor) {
            this.result = (DBCursor)retval;
        } else if (retval instanceof MongoIterable) {
            this.iterableResult = (MongoIterable)retval;
        } else {
            this.resultList = new ArrayList<DBObject>(1);
            if (retval instanceof Collection) {
                boolean objects = true;
                for (Object obj : (Collection)retval) {
                    if (obj instanceof DBObject) continue;
                    objects = false;
                    break;
                }
                if (objects) {
                    this.resultList.addAll((Collection)retval);
                } else {
                    this.resultList.add((DBObject)retval);
                }
            } else if (retval instanceof DBObject) {
                this.resultList.add((DBObject)retval);
            } else {
                this.resultList.add((DBObject)new BasicDBObject("result", retval));
            }
        }
    }

    protected void setExecutionResult(WriteResult writeResult) {
        this.writeResult = writeResult;
    }

    public DBSEntity getSourceEntity() {
        return this.collection;
    }
}

