/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.data;

import com.dbeaver.db.mongodb.MongoUtils;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.ee.model.document.data.DBAbstractDocument;
import com.dbeaver.ee.model.document.data.DBMapValue;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class MongoDocument
extends DBAbstractDocument<MGDataSource, DBObject> {
    private static final Log log = Log.getLog(MongoDocument.class);

    public MongoDocument(@NotNull MGDataSource dataSource, @NotNull DBObject sourceData) {
        super((DBPDataSource)dataSource, (Object)sourceData);
    }

    @Nullable
    public Object getDocumentId() {
        return ((DBObject)this.getRawValue()).get("_id");
    }

    public Object getDocumentProperty(String name) {
        Object id;
        if (name.equals("id")) {
            return this.getDocumentId();
        }
        if (name.equals("createTime") && (id = ((DBObject)this.getRawValue()).get("_id")) instanceof ObjectId) {
            return ((ObjectId)id).getDate();
        }
        return null;
    }

    @NotNull
    public String getDocumentContentType() {
        return "text/json";
    }

    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull OutputStream stream, Charset charset) throws DBException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStreamWriter out = new OutputStreamWriter(stream, charset);){
            ((MGDataSource)this.getDataSource()).serializeDocument((Map)MongoUtils.unwrapMongoValue(null, (Object)this.getRootNode()), (Writer)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull InputStream stream, Charset charset) throws DBException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader reader = new InputStreamReader(stream);){
            this.rawMap = new DBMapValue((DBPDataSource)((MGDataSource)this.dataSource), (Object)this, ((MGDataSource)this.dataSource).deserializeDocument(reader));
            this.rawValue = this.makeMongoDocument((DBMapValue<MGDataSource>)this.rawMap);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.markModified();
    }

    protected DBMapValue<MGDataSource> makeRawMap() {
        return (DBMapValue)MongoUtils.wrapMongoValue((MGDataSource)this.getDataSource(), this.rawValue, null);
    }

    private DBObject makeMongoDocument(DBMapValue<MGDataSource> rawMap) {
        BasicDBObject document = BasicDBObject.parse((String)rawMap.toJson());
        Object docId = document.get("_id");
        if (docId instanceof String && ObjectId.isValid((String)((String)docId))) {
            try {
                document.put((Object)"_id", (Object)new ObjectId((String)docId));
            }
            catch (Exception e) {
                log.error((Object)"Error converting object ID", (Throwable)e);
            }
        }
        return document;
    }
}

