/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb;

import com.dbeaver.db.mongodb.MongoUtils;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPInformationProvider;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class MGDataSourceProvider
implements DBPDataSourceProvider,
DBPInformationProvider {
    private static final Log log = Log.getLog(MGDataSourceProvider.class);

    protected MGDataSourceProvider() {
        Logger mongoLogger = Logger.getLogger("org.mongodb");
        mongoLogger.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                log.debug((Object)("MONGO " + record.getLevel().getName() + ": " + record.getMessage()));
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        mongoLogger.setLevel(Level.WARNING);
    }

    public void init(@NotNull DBPPlatform platform) {
    }

    public long getFeatures() {
        return 2L;
    }

    public DBPPropertyDescriptor[] getConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, DBPConnectionConfiguration connectionInfo) throws DBException {
        return new DBPPropertyDescriptor[]{new PropertyDescriptor("Connection", "serverSelectTimeout", "Server Select Timeout", "The server select timeout in milliseconds.", Long.class, false, (Object)String.valueOf(5000), null, true), new PropertyDescriptor("Connection", "connectTimeout", "Connect Timeout", "The connection timeout in milliseconds.", Long.class, false, null, null, true), new PropertyDescriptor("Connection", "socketTimeout", "Socket Timeout", "The socket timeout in milliseconds.", Long.class, false, null, null, true), new PropertyDescriptor("Connection", "socketKeepAlive", "Socket Keep Alive", "This flag controls the socket keep alive feature that keeps a connection alive through firewalls.", Boolean.class, false, (Object)true, null, true), new PropertyDescriptor("Connection", "maxConnectionIdleTime", "Max Connection Idle Time", "The maximum idle time of a pooled connection.", Long.class, false, null, null, true), new PropertyDescriptor("Connection", "maxConnectionLifeTime", "Max Connection Life Time", "The maximum life time of a pooled connection.", Long.class, false, null, null, true), new PropertyDescriptor("Connection", "maxWaitTime", "Max Wait Time", "The maximum wait time in milliseconds that a thread may wait for a connection to become available.", Long.class, false, null, null, true), new PropertyDescriptor("Connection", "singleNodeMode", "Single node mode", "Forces single mode node if there is just one server node configured.\nMakes sense in case of SSH tunnels.", Boolean.class, false, null, null, true), new PropertyDescriptor("Heartbeat", "heartbeatConnectTimeout", "Heartbeat Connect Timeout", "The connect timeout for connections used for the cluster heartbeat.", Long.class, false, null, null, true), new PropertyDescriptor("Heartbeat", "heartbeatSocketTimeout", "Heartbeat Socket Timeout", "The socket timeout for connections used for the cluster heartbeat.", Long.class, false, null, null, true), new PropertyDescriptor("Heartbeat", "heartbeatFrequency", "Heartbeat Frequency", "The heartbeat frequency.", Integer.class, false, null, null, true)};
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        String url = connectionInfo.getUrl();
        if (!CommonUtils.isEmpty((String)url)) {
            return url;
        }
        return "mongo://" + connectionInfo.getHostName() + ":" + connectionInfo.getHostPort() + "/" + connectionInfo.getDatabaseName();
    }

    @Nullable
    public String getObjectInformation(@NotNull DBPObject object, @NotNull String infoType) {
        if (object instanceof DBPDataSourceContainer && infoType.equals("targetAddress")) {
            DBPConnectionConfiguration connectionInfo = ((DBPDataSourceContainer)object).getConnectionConfiguration();
            String url = connectionInfo.getUrl();
            if (!CommonUtils.isEmpty((String)url)) {
                Object[] hostnames = MongoUtils.getHostnamesFromURL(url);
                if (!ArrayUtils.isEmpty((Object[])hostnames)) {
                    return String.join((CharSequence)", ", (CharSequence[])hostnames);
                }
                return url;
            }
            return String.valueOf(connectionInfo.getHostName()) + ":" + connectionInfo.getHostPort();
        }
        return null;
    }
}

