/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable.exec;

import com.dbeaver.db.google.bigtable.data.BigTableDocument;
import com.dbeaver.db.google.bigtable.exec.BigTableBaseStatement;
import com.dbeaver.db.google.bigtable.exec.BigTableScanStatement;
import com.dbeaver.db.google.bigtable.exec.BigTableSession;
import com.dbeaver.ee.model.document.exec.DocumentResultSet;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigtable.data.v2.models.Row;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCResultSetSampleProvider;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;

public class BigTableResultSet
extends DocumentResultSet<BigTableSession, BigTableBaseStatement>
implements DBCResultSetSampleProvider {
    private final ServerStream<Row> rows;
    private Iterator<Row> rowIterator;
    private DBCResultSetMetaData metaData;
    private Row curRow;

    BigTableResultSet(BigTableBaseStatement statement, ServerStream<Row> rows) {
        super((DBCStatement)statement);
        this.rows = rows;
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        if (index == 0) {
            return this.getRowDocument(this.curRow);
        }
        throw new DBCException("Index out of range (" + index + ")");
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        return this.getRowDocument(this.curRow);
    }

    public boolean nextRow() throws DBCException {
        try {
            if (this.rowIterator == null) {
                this.rowIterator = this.rows.iterator();
            }
            if (this.rowIterator.hasNext()) {
                this.curRow = this.rowIterator.next();
                ++this.itemNumber;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new DBCException("Error fetch BigTable row", (Throwable)e);
        }
    }

    protected String getSourceEntityName() {
        return ((BigTableBaseStatement)this.statement).getEntityName();
    }

    public boolean moveTo(int position) throws DBCException {
        this.rowIterator = null;
        this.itemNumber = position;
        while (position-- > 0) {
            this.nextRow();
        }
        return true;
    }

    @NotNull
    public DBCResultSetMetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            this.metaData = new LocalResultSetMeta(Collections.singletonList(new DocumentResultSet.DynamicDocumentAttribute((DocumentResultSet)this)));
        }
        return this.metaData;
    }

    public String getResultSetName() throws DBCException {
        return null;
    }

    public Object getFeature(String name) {
        return null;
    }

    public void close() {
        if (this.rowIterator != null) {
            this.rowIterator = null;
        }
        this.rows.cancel();
    }

    @NotNull
    public List<Object[]> getSampleRows(DBCSession session, int maxRows) throws DBCException {
        ArrayList<Object[]> sample = new ArrayList<Object[]>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BigTableResultSet rsCopy = ((BigTableBaseStatement)this.statement).executeWithResults();){
            Iterator sampleIter = rsCopy.rows.iterator();
            while (sampleIter.hasNext() && maxRows-- > 0 && !session.getProgressMonitor().isCanceled()) {
                sample.add(new Object[]{this.getRowDocument((Row)sampleIter.next())});
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return sample;
    }

    @NotNull
    private BigTableDocument getRowDocument(Row row) {
        return new BigTableDocument(((BigTableSession)this.getSession()).getDataSource(), this.statement instanceof BigTableScanStatement ? ((BigTableScanStatement)this.statement).getTable() : null, row);
    }
}

