/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.google.bigtable;

import com.dbeaver.db.google.bigtable.data.BigTableDocument;
import com.dbeaver.db.google.bigtable.model.BigTableDataSource;
import com.dbeaver.ee.model.document.data.DBMapValue;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowCell;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.protobuf.ByteString;
import java.util.LinkedHashMap;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;

public class BigTableUtils {
    public static Object getRawValue(@NotNull ByteString value) {
        return value.toStringUtf8();
    }

    public static JsonElement getJsonAttributeValue(RowCell value) {
        return new JsonPrimitive(value.getValue().toStringUtf8());
    }

    public static DBMapValue<BigTableDataSource> makeRawMap(@NotNull BigTableDataSource dataSource, BigTableDocument document, Row row) {
        LinkedHashMap<String, Object> rawMap = new LinkedHashMap<String, Object>();
        rawMap.put("RowKey", row.getKey());
        for (RowCell cell : row.getCells()) {
            rawMap.put(cell.getQualifier().toStringUtf8(), BigTableUtils.getRawValue(cell.getValue()));
        }
        return new DBMapValue((DBPDataSource)dataSource, (Object)document, rawMap);
    }
}

