/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.grant.revokegrant;

import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.grant.AbstractObjectPermissionChange;
import liquibase.ext.ora.grant.addgrant.GrantObjectPermissionChange;
import liquibase.ext.ora.grant.revokegrant.RevokeObjectPermissionStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="revokeObjectPermission", description="Revoke Schema Object Permission", priority=201)
public class RevokeObjectPermissionChange
extends AbstractObjectPermissionChange {
    public RevokeObjectPermissionChange() {
    }

    public RevokeObjectPermissionChange(AbstractObjectPermissionChange other) {
        super(other);
    }

    public SqlStatement[] generateStatements(Database database) {
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        RevokeObjectPermissionStatement statement = new RevokeObjectPermissionStatement(schemaName, this.getObjectName(), this.getRecipientList());
        statement.setSelect(this.getSelect());
        statement.setUpdate(this.getUpdate());
        statement.setInsert(this.getInsert());
        statement.setDelete(this.getDelete());
        statement.setExecute(this.getExecute());
        statement.setIndex(this.getIndex());
        statement.setReferences(this.getReferences());
        return new SqlStatement[]{statement};
    }

    @Override
    public String getConfirmationMessage() {
        return "Revoking grants on " + this.getObjectName() + " that had been given to " + this.getRecipientList();
    }

    protected Change[] createInverses() {
        GrantObjectPermissionChange inverse = new GrantObjectPermissionChange(this);
        return new Change[]{inverse};
    }
}

