/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.result.facets;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class NumericRange {
    private final String name;
    private final Double min;
    private final Double max;
    private final long count;

    public NumericRange(String name, Double min, Double max, long count) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.count = count;
    }

    public String name() {
        return this.name;
    }

    public Double min() {
        return this.min;
    }

    public Double max() {
        return this.max;
    }

    public long count() {
        return this.count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("name='").append(this.name).append('\'');
        if (this.min != null) {
            sb.append(", min=").append(this.min);
        }
        if (this.max != null) {
            sb.append(", max=").append(this.max);
        }
        sb.append(", count=").append(this.count);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NumericRange that = (NumericRange)o;
        if (this.count != that.count) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.min != null ? !this.min.equals(that.min) : that.min != null) {
            return false;
        }
        return this.max != null ? this.max.equals(that.max) : that.max == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.min != null ? this.min.hashCode() : 0);
        result = 31 * result + (this.max != null ? this.max.hashCode() : 0);
        result = 31 * result + (int)(this.count ^ this.count >>> 32);
        return result;
    }
}

