/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.registry;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.Map;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPDataSourceOriginProvider;
import org.jkiss.utils.CommonUtils;

public class DataSourceOriginProviderCloud
implements DBPDataSourceOriginProvider {
    private static final Log log = Log.getLog(DataSourceOriginProviderCloud.class);

    public DBPDataSourceOrigin getOrigin(Map<String, Object> configuration) {
        String providerId = CommonUtils.toString((Object)configuration.get("cloud-provider"));
        CloudProviderDescriptor provider = CloudProviderRegistry.getInstance().getCloudProvider(providerId);
        if (provider == null) {
            log.error((Object)("Cloud provider '" + providerId + "' not found"));
            return null;
        }
        String cloudId = CommonUtils.toString((Object)configuration.get("cloud-id"));
        CPCloud<?, ?> cloud = CPCloudUtils.getCloud(provider, cloudId);
        if (cloud != null) {
            String zoneId = CommonUtils.toString((Object)configuration.get("cloud-zone-id"));
            CPCloudZone zone = CPCloudUtils.findZone(cloud, zoneId);
            if (zone != null) {
                return provider.getInstance().createDataSourceOrigin(cloud, zone, configuration);
            }
            log.error((Object)("Cloud '" + cloudId + "' zone '" + zoneId + "' not found"));
        } else {
            log.error((Object)("Cloud '" + cloudId + "' not found"));
        }
        return null;
    }
}

