/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.registry;

import com.dbeaver.cloud.model.CPCloudProvider;
import com.dbeaver.cloud.registry.CloudDatabaseServiceDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;

public class CloudProviderDescriptor
extends AbstractContextDescriptor {
    private final String id;
    private final String label;
    private final String description;
    private final AbstractDescriptor.ObjectType implClass;
    private final DBPImage icon;
    private CPCloudProvider instance;
    private List<CloudDatabaseServiceDescriptor> databaseServices = new ArrayList<CloudDatabaseServiceDescriptor>();

    protected CloudProviderDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.implClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
        IConfigurationElement[] iConfigurationElementArray = config.getChildren("databaseService");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement dsElement = iConfigurationElementArray[n2];
            this.databaseServices.add(new CloudDatabaseServiceDescriptor(dsElement));
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public synchronized CPCloudProvider getInstance() {
        if (this.instance == null) {
            try {
                this.instance = (CPCloudProvider)this.implClass.createInstance(CPCloudProvider.class);
            }
            catch (DBException e) {
                throw new IllegalStateException("Error instantiating cloud provider " + this.id, e);
            }
        }
        return this.instance;
    }

    public List<CloudDatabaseServiceDescriptor> getDatabaseServices() {
        return this.databaseServices;
    }

    public String toString() {
        return this.id;
    }
}

