/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.db.dynamodb.model.DynamoTableAttribute;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraintColumn;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;

public class DynamoTableKey
implements DBSTableConstraint {
    private static final Log log = Log.getLog(DynamoTableKey.class);
    private final DynamoTable table;
    private List<KeyAttribute> attributes;

    public DynamoTableKey(DBRProgressMonitor monitor, DynamoTable table, List<KeySchemaElement> keySchema) throws DBException {
        this.table = table;
        this.attributes = new ArrayList<KeyAttribute>();
        if (keySchema != null) {
            int i = 0;
            while (i < keySchema.size()) {
                KeySchemaElement keySchemaElement = keySchema.get(i);
                DBSEntityAttribute attribute = table.getAttribute(monitor, keySchemaElement.attributeName());
                if (attribute instanceof DynamoTableAttribute) {
                    this.attributes.add(new KeyAttribute((DynamoTableAttribute)attribute, i, keySchemaElement));
                } else {
                    log.error((Object)("Can't find key attribute " + keySchemaElement));
                }
                ++i;
            }
        }
    }

    @NotNull
    public DynamoDataSource getDataSource() {
        return (DynamoDataSource)this.table.getDataSource();
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return "Key";
    }

    public String getDescription() {
        return null;
    }

    @NotNull
    public DynamoTable getParentObject() {
        return this.table;
    }

    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return DBSEntityConstraintType.PRIMARY_KEY;
    }

    public boolean isPersisted() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return this.getName();
    }

    @Nullable
    public List<? extends DBSEntityAttributeRef> getAttributeReferences(DBRProgressMonitor monitor) throws DBException {
        return this.attributes;
    }

    public List<KeyAttribute> getAttributes() {
        return this.attributes;
    }

    public boolean containsAttribute(String keyName) {
        for (KeyAttribute ka : this.attributes) {
            if (!ka.getName().equals(keyName)) continue;
            return true;
        }
        return false;
    }

    public class KeyAttribute
    implements DBSTableConstraintColumn {
        private final DynamoTableAttribute attribute;
        private final int position;
        private final KeySchemaElement keySchemaElement;

        public KeyAttribute(DynamoTableAttribute attribute, int position, KeySchemaElement keySchemaElement) {
            this.attribute = attribute;
            this.position = position;
            this.keySchemaElement = keySchemaElement;
        }

        @NotNull
        public DynamoDataSource getDataSource() {
            return DynamoTableKey.this.getDataSource();
        }

        public DynamoTableKey getParentObject() {
            return DynamoTableKey.this;
        }

        @Property(viewable=true)
        @NotNull
        public String getName() {
            return this.attribute.getName();
        }

        public String getDescription() {
            return null;
        }

        public boolean isPersisted() {
            return true;
        }

        @NotNull
        public DynamoTableAttribute getAttribute() {
            return this.attribute;
        }

        public int getOrdinalPosition() {
            return this.position;
        }

        @Property(viewable=true)
        public String getKeyType() {
            return this.keySchemaElement.keyTypeAsString();
        }
    }
}

