/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.ee.model.NoSQLDialect;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class DynamoSQLDialect
extends NoSQLDialect {
    public static final DynamoSQLDialect INSTANCE = new DynamoSQLDialect();

    public DynamoSQLDialect() {
        this.addKeywords(Arrays.asList("tableName", "indexName", "select", "attributesToGet", "limit", "consistentRead", "keyConditions", "queryFilter", "conditionalOperator", "scanIndexForward", "exclusiveStartKey", "returnConsumedCapacity", "projectionExpression", "filterExpression", "keyConditionExpression", "expressionAttributeNames", "expressionAttributeValues"), DBPKeywordType.KEYWORD);
    }

    @NotNull
    public String getDialectId() {
        return "dynamodb";
    }

    @NotNull
    public String getDialectName() {
        return "DynamoQL";
    }

    @NotNull
    public DBPIdentifierCase storesUnquotedCase() {
        return DBPIdentifierCase.MIXED;
    }

    public boolean validIdentifierStart(char c) {
        return super.validIdentifierStart(c) || c == '_';
    }

    public boolean supportsAliasInSelect() {
        return false;
    }

    public boolean supportsAliasInUpdate() {
        return false;
    }

    public boolean supportsSubqueries() {
        return false;
    }

    @NotNull
    public String escapeScriptValue(DBSAttributeBase attribute, @NotNull Object value, @NotNull String strValue) {
        if (value instanceof String) {
            return String.valueOf('\'') + this.escapeString(strValue) + '\'';
        }
        return strValue;
    }
}

