/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.model;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import com.dbeaver.db.dynamodb.data.DynamoDocument;
import com.dbeaver.db.dynamodb.exec.DynamoExecutionContext;
import com.dbeaver.db.dynamodb.model.DynamoBackup;
import com.dbeaver.db.dynamodb.model.DynamoDataSourceInfo;
import com.dbeaver.db.dynamodb.model.DynamoDataType;
import com.dbeaver.db.dynamodb.model.DynamoGlobalTable;
import com.dbeaver.db.dynamodb.model.DynamoSQLDialect;
import com.dbeaver.db.dynamodb.model.DynamoServerType;
import com.dbeaver.db.dynamodb.model.DynamoStructureAssistant;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.ee.model.NoSQLDataSource;
import com.dbeaver.ee.model.document.DocumentDataManager;
import com.dbeaver.ee.model.document.data.DBMapValue;
import com.dbeaver.net.auth.iam.AuthModelIAMCredentials;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.auth.DBAAuthCredentials;
import org.jkiss.dbeaver.model.auth.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BackupSummary;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.dynamodb.model.Endpoint;
import software.amazon.awssdk.services.dynamodb.model.GlobalTable;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;

public class DynamoDataSource
extends NoSQLDataSource<DynamoExecutionContext>
implements DBPDataSource,
DocumentDataManager<DynamoDataSource, Map<String, AttributeValue>>,
DBPRefreshableObject,
DBPDataTypeProvider,
DBPObjectStatisticsCollector,
IAdaptable {
    private static final Log log = Log.getLog(DynamoDataSource.class);
    private static Gson JSON_BUILDER = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").registerTypeAdapter(AttributeValue.class, (Object)new DynamoDocument.AttributeValueConverter()).serializeNulls().create();
    private static final int DEFAULT_TABLES_LIMIT = 100;
    private TableCache tableCache = new TableCache();
    private volatile List<DynamoGlobalTable> globalTables;
    private volatile List<DynamoBackup> backups;
    private DynamoDataSourceInfo info;
    private final List<DynamoDataType> dataTypes = new ArrayList<DynamoDataType>();
    private final DynamoDbClient client;
    private DynamoServerType serverType;
    private Region awsRegion;
    private boolean hasStatistics;

    public DynamoDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        super(container);
        this.client = this.createClient(monitor);
        try {
            if (this.awsRegion != null) {
                log.debug((Object)("Connect to DynamoDB instance at " + this.awsRegion.id()));
            }
            if (this.serverType == DynamoServerType.STANDALONE) {
                log.debug((Object)"Connected to local DynamoDB. Check connection.");
                this.client.listTables();
            } else {
                DescribeEndpointsResponse endpoints = this.client.describeEndpoints();
                for (Endpoint endpoint : endpoints.endpoints()) {
                    log.debug((Object)("DynamoDB endpoint: " + endpoint.toString()));
                }
            }
        }
        catch (Exception e) {
            throw new DBException("Error connecting to DynamoDB server", (Throwable)e);
        }
        DynamoDataType.TypeName[] typeNameArray = DynamoDataType.TypeName.values();
        int n = typeNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            DynamoDataType.TypeName typeName = typeNameArray[n2];
            this.dataTypes.add(new DynamoDataType(this, typeName));
            ++n2;
        }
        this.executionContext = new DynamoExecutionContext(this, "Main Dynamo Connection");
        ((DynamoExecutionContext)this.executionContext).connect(monitor);
    }

    public DynamoDbClient getClient() {
        return this.client;
    }

    private DynamoDbClient createClient(DBRProgressMonitor monitor) throws DBException {
        AuthModelIAMCredentials credentials;
        DBPConnectionConfiguration connectionCfg = this.getContainer().getActualConnectionConfiguration();
        String regionName = connectionCfg.getProviderProperty("regionName");
        this.awsRegion = regionName == null ? Region.AWS_GLOBAL : Region.of((String)regionName);
        Properties connectionProps = new Properties();
        DBAAuthModel authModel = connectionCfg.getAuthModel();
        DBAAuthCredentials amCreds = authModel.loadCredentials(this.getContainer(), connectionCfg);
        if (authModel.getClass() == AuthModelDatabaseNative.class) {
            AuthModelDatabaseNativeCredentials nativeCreds = (AuthModelDatabaseNativeCredentials)amCreds;
            credentials = new AuthModelIAMCredentials();
            credentials.setUserName(nativeCreds.getUserName());
            credentials.setUserPassword(nativeCreds.getUserPassword());
            authModel.initAuthentication(monitor, (DBPDataSource)this, amCreds, connectionCfg, connectionProps);
        } else {
            Object awsCredentials = authModel.initAuthentication(monitor, (DBPDataSource)this, amCreds, connectionCfg, connectionProps);
            if (awsCredentials instanceof AuthModelIAMCredentials) {
                credentials = (AuthModelIAMCredentials)awsCredentials;
            } else {
                throw new DBCException("Unsupported auth credentials: " + awsCredentials.getClass().getName());
            }
        }
        try {
            AwsCredentialsProvider credentialsProvider = credentials.getAuthCredentialsProvider(connectionCfg);
            this.serverType = (DynamoServerType)CommonUtils.valueOf(DynamoServerType.class, (String)connectionCfg.getProviderProperty("serverType"), (Enum)DynamoServerType.AWS);
            DynamoDbClientBuilder builder = (DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().region(this.awsRegion)).credentialsProvider(credentialsProvider);
            if (this.serverType == DynamoServerType.STANDALONE) {
                try {
                    builder.endpointOverride(new URI(connectionCfg.getHostName()));
                }
                catch (URISyntaxException e) {
                    throw new DBException("Wrong endpoint URI", (Throwable)e);
                }
            }
            DynamoDbClient dynamoDbClient = (DynamoDbClient)builder.build();
            return dynamoDbClient;
        }
        finally {
            authModel.endAuthentication(this.getContainer(), connectionCfg, connectionProps);
        }
    }

    public DynamoSQLDialect getSQLDialect() {
        return DynamoSQLDialect.INSTANCE;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.info = new DynamoDataSourceInfo(this);
    }

    @NotNull
    public DynamoExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        DynamoExecutionContext context = new DynamoExecutionContext(this, purpose);
        context.connect(monitor);
        return context;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new DynamoStructureAssistant(this));
        }
        return null;
    }

    public void shutdown(DBRProgressMonitor monitor) {
        super.shutdown(monitor);
        this.client.close();
    }

    public TableCache getTableCache() {
        return this.tableCache;
    }

    @Association
    public List<DynamoTable> getTables(DBRProgressMonitor monitor) throws DBException {
        return this.tableCache.getAllObjects(monitor, this);
    }

    @Association
    public DynamoTable getTable(DBRProgressMonitor monitor, String name) throws DBException {
        return (DynamoTable)this.tableCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public List<DynamoGlobalTable> getGlobalTables(DBRProgressMonitor monitor) {
        if (this.globalTables == null) {
            ArrayList<DynamoGlobalTable> tableList = new ArrayList<DynamoGlobalTable>();
            String lastTableName = null;
            do {
                ListGlobalTablesRequest lgtRequest = (ListGlobalTablesRequest)ListGlobalTablesRequest.builder().limit(Integer.valueOf(100)).exclusiveStartGlobalTableName(lastTableName).build();
                ListGlobalTablesResponse lgtResponse = this.client.listGlobalTables(lgtRequest);
                lastTableName = lgtResponse.lastEvaluatedGlobalTableName();
                for (GlobalTable globalTable : lgtResponse.globalTables()) {
                    DynamoGlobalTable table = new DynamoGlobalTable(this, globalTable);
                    tableList.add(table);
                }
            } while (lastTableName != null);
            this.globalTables = tableList;
        }
        return this.globalTables;
    }

    @Association
    public List<DynamoBackup> getBackups(DBRProgressMonitor monitor) {
        if (this.backups == null) {
            ArrayList<DynamoBackup> backupList = new ArrayList<DynamoBackup>();
            for (BackupSummary backupSummary : this.client.listBackups().backupSummaries()) {
                DynamoBackup backup = new DynamoBackup(this, backupSummary);
                backupList.add(backup);
            }
            this.backups = backupList;
        }
        return this.backups;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getTables(monitor);
    }

    public DynamoTable getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (DynamoTable)this.tableCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return DynamoTable.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.getTables(monitor);
        this.getGlobalTables(monitor);
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        for (DynamoDataType dataType : this.dataTypes) {
            if (!dataType.getTypeName().equals(typeName)) continue;
            return dataType.getDataKind();
        }
        return DBPDataKind.OBJECT;
    }

    public DynamoDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        return this.getLocalDataType(typeFullName);
    }

    public List<DynamoDataType> getLocalDataTypes() {
        return this.dataTypes;
    }

    public DynamoDataType getLocalDataType(String typeName) {
        for (DynamoDataType dataType : this.dataTypes) {
            if (!dataType.getTypeName().equals(typeName)) continue;
            return dataType;
        }
        return null;
    }

    public DynamoDataType getLocalDataType(int typeID) {
        for (DynamoDataType dataType : this.dataTypes) {
            if (dataType.getTypeID() != typeID) continue;
            return dataType;
        }
        return null;
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return DynamoDataType.TypeName.STRING.getTypeName();
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableCache.clearCache();
        this.globalTables = null;
        this.backups = null;
        return this;
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        try {
            for (DynamoTable table : this.getTables(monitor)) {
                table.getTableDescription(monitor);
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }

    public void serializeDocument(Map<String, AttributeValue> document, Writer writer) {
        JSON_BUILDER.toJson(document, (Appendable)writer);
    }

    public Map<String, Object> deserializeDocument(Reader reader) {
        return JSONUtils.parseMap((Gson)JSON_BUILDER, (Reader)reader);
    }

    public DBMapValue<DynamoDataSource> convertNativeDocumentToMap(Map<String, AttributeValue> o) {
        return DynamoDBUtils.makeDocumentMap(this, null, o);
    }

    public Map<String, AttributeValue> convertMapToNativeDocument(DBMapValue<DynamoDataSource> map) {
        return DynamoDBUtils.makeDynamoDocument(map);
    }

    public DBSDataType getDocumentDataType(int typeId) {
        for (DynamoDataType dt : this.dataTypes) {
            if (dt.getTypeID() != typeId) continue;
            return dt;
        }
        return null;
    }

    public class TableCache
    extends BasicObjectCache<DynamoDataSource, DynamoTable> {
        @NotNull
        public List<DynamoTable> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable DynamoDataSource dataSource) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<DynamoTable> tableList = new ArrayList<DynamoTable>();
                String lastTableName = null;
                do {
                    ListTablesRequest ltRequest = (ListTablesRequest)ListTablesRequest.builder().limit(Integer.valueOf(100)).exclusiveStartTableName(lastTableName).build();
                    ListTablesResponse listTablesResponse = DynamoDataSource.this.client.listTables(ltRequest);
                    lastTableName = listTablesResponse.lastEvaluatedTableName();
                    for (String tableName : listTablesResponse.tableNames()) {
                        DynamoTable table = new DynamoTable(dataSource, tableName, true);
                        tableList.add(table);
                    }
                } while (lastTableName != null);
                this.setCache(tableList);
            }
            return this.getCachedObjects();
        }
    }
}

