/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import com.dbeaver.db.dynamodb.data.DynamoDocument;
import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

public class DynamoUpdateStatement
extends DynamoBaseStatement {
    private DynamoTable table;
    private DBSAttributeBase[] valueAttributes;
    private DBSAttributeBase[] keyAttributes;
    private Object[] rowValues;

    public DynamoUpdateStatement(DynamoSession session, DBCExecutionSource source, DynamoTable table, DBSAttributeBase[] updateAttributes, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        super(session, source);
        this.table = table;
        this.valueAttributes = updateAttributes;
        this.keyAttributes = keyAttributes;
        this.rowValues = rowValues;
    }

    public void setRowValues(Object[] rowValues) {
        this.rowValues = rowValues;
    }

    @Nullable
    public String getQueryString() {
        LinkedHashMap<String, String> exprAttrNames = new LinkedHashMap<String, String>();
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(this.table.getName());
        int i = 0;
        while (i < this.valueAttributes.length) {
            DBSAttributeBase va = this.valueAttributes[i];
            String encodedAttrName = this.getEncodedAttrName(exprAttrNames, va);
            Object attrValue = this.rowValues[i];
            if (DBUtils.isNullValue((Object)attrValue)) {
                sql.append(" REMOVE ").append(encodedAttrName);
            } else {
                sql.append(" SET ").append(encodedAttrName).append(" = ").append(this.getEncodedValueId(i));
            }
            ++i;
        }
        sql.append("\nWHERE ");
        try {
            boolean first = true;
            Map<String, AttributeValue> attrKey = this.getKeyValues(((DynamoSession)this.getSession()).getProgressMonitor());
            for (Map.Entry<String, AttributeValue> ae : attrKey.entrySet()) {
                if (!first) {
                    sql.append(" AND ");
                }
                first = false;
                sql.append(ae.getKey()).append(" = '").append(DynamoDBUtils.getRawAttributeValue((DynamoDataSource)this.table.getDataSource(), null, ae.getValue())).append("'");
            }
        }
        catch (DBException e) {
            sql.append(e.getMessage());
        }
        return sql.toString();
    }

    public boolean executeStatement() throws DBCException {
        DBRProgressMonitor monitor = ((DynamoSession)this.getSession()).getProgressMonitor();
        try {
            Map<String, AttributeValue> attrKey = this.getKeyValues(monitor);
            StringBuilder updateExpr = new StringBuilder();
            LinkedHashMap<String, String> exprAttrNames = new LinkedHashMap<String, String>();
            LinkedHashMap<String, AttributeValue> exprAttrValues = new LinkedHashMap<String, AttributeValue>();
            int i = 0;
            while (i < this.valueAttributes.length) {
                DBSAttributeBase va = this.valueAttributes[i];
                String encodedAttrName = this.getEncodedAttrName(exprAttrNames, va);
                String encodedAttrValueId = this.getEncodedValueId(i);
                Object attrValue = this.rowValues[i];
                if (DBUtils.isNullValue((Object)attrValue)) {
                    updateExpr.append(" REMOVE ").append(encodedAttrName);
                } else {
                    updateExpr.append(" SET ").append(encodedAttrName).append(" = ").append(encodedAttrValueId);
                    exprAttrValues.put(encodedAttrValueId, DynamoDBUtils.getAttributeValueFromPOJO(attrValue));
                }
                ++i;
            }
            UpdateItemRequest uir = (UpdateItemRequest)UpdateItemRequest.builder().tableName(this.table.getName()).key(attrKey).updateExpression(updateExpr.toString().trim()).expressionAttributeNames(exprAttrNames).expressionAttributeValues(exprAttrValues).build();
            ((DynamoSession)this.getSession()).getDataSource().getClient().updateItem(uir);
            return false;
        }
        catch (Throwable e) {
            throw new DBCException("Error updating item", e);
        }
    }

    @NotNull
    private Map<String, AttributeValue> getKeyValues(DBRProgressMonitor monitor) throws DBException {
        LinkedHashMap<String, AttributeValue> attrKey = new LinkedHashMap<String, AttributeValue>();
        int i = 0;
        while (i < this.keyAttributes.length) {
            DBSAttributeBase ka = this.keyAttributes[i];
            Object attrValue = this.rowValues[this.valueAttributes.length + i];
            if (attrValue instanceof DynamoDocument) {
                attrKey.putAll(((DynamoDocument)((Object)attrValue)).getKeyValues(monitor));
            } else {
                attrKey.put(ka.getName(), DynamoDBUtils.getAttributeValueFromPOJO(attrValue));
            }
            ++i;
        }
        return attrKey;
    }

    private String getEncodedAttrName(Map<String, String> exprAttrNames, DBSAttributeBase attr) {
        DBSObject parentObj;
        String name = "#" + CommonUtils.escapeIdentifier((String)attr.getName());
        exprAttrNames.put(name, attr.getName());
        if (attr instanceof DBSObject && (parentObj = ((DBSObject)attr).getParentObject()) instanceof DBSAttributeBase) {
            DBSAttributeBase parentAttr = (DBSAttributeBase)parentObj;
            if (parentAttr instanceof DBDAttributeBinding && ((DBDAttributeBinding)parentAttr).isPseudoAttribute() || parentAttr.getDataKind() == DBPDataKind.DOCUMENT && parentObj.getParentObject() == null) {
                return name;
            }
            name = String.valueOf(this.getEncodedAttrName(exprAttrNames, parentAttr)) + "." + name;
        }
        return name;
    }

    @NotNull
    private String getEncodedValueId(int i) {
        return ":val" + i;
    }

    @Nullable
    public DBCResultSet openResultSet() throws DBCException {
        return null;
    }

    @Override
    public DynamoTable getSourceEntity() {
        return this.table;
    }
}

