/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoResultIterable;
import com.dbeaver.db.dynamodb.exec.DynamoSQL;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.db.dynamodb.model.DynamoTableKey;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.paginators.ScanIterable;

public class DynamoScanStatement
extends DynamoBaseStatement {
    private final DynamoTable table;
    private ScanRequest scanRequest;
    protected Throwable executeError;
    private DBDDataFilter dataFilter;
    private DynamoResultIterable resultSet;

    public DynamoScanStatement(DynamoSession session, DynamoTable table) {
        super(session);
        this.table = table;
    }

    @Override
    public DynamoTable getSourceEntity() {
        return this.table;
    }

    public String getQueryString() {
        return "SCAN TABLE " + this.table.getName();
    }

    public boolean executeStatement() throws DBCException {
        if (((DynamoSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        try {
            Object condString;
            ScanRequest.Builder srBuilder = ScanRequest.builder().tableName(this.table.getName());
            long totalRows = this.limit;
            if (totalRows > 0L && this.offset > 0L) {
                totalRows += this.offset;
            }
            if (totalRows > 0L) {
                srBuilder.limit(Integer.valueOf((int)totalRows));
            }
            if (this.dataFilter != null && this.dataFilter.hasConditions()) {
                condString = new StringBuilder();
                SQLUtils.appendConditionString((DBDDataFilter)this.dataFilter, (DBPDataSource)((DynamoSession)this.getSession()).getDataSource(), null, (StringBuilder)condString, (boolean)true);
                try {
                    Expression expr = CCJSqlParserUtil.parseCondExpression((String)((StringBuilder)condString).toString());
                    LinkedHashMap<String, Condition> keyConditions = new LinkedHashMap<String, Condition>();
                    DynamoSQL.parseExpression(keyConditions, expr);
                    if (!keyConditions.isEmpty()) {
                        this.addScanConditions(srBuilder, keyConditions);
                    }
                }
                catch (Exception e) {
                    throw new DBCException("Error creating scan conditions", (Throwable)e);
                }
            }
            if (this.dataFilter != null && this.dataFilter.hasOrdering()) {
                condString = this.dataFilter.getOrderConstraints().iterator();
                while (condString.hasNext()) {
                    DBDAttributeConstraint cfr_ignored_0 = (DBDAttributeConstraint)condString.next();
                }
            }
            ScanRequest scanRequest = (ScanRequest)srBuilder.build();
            ScanIterable scanResponses = ((DynamoDataSource)this.table.getDataSource()).getClient().scanPaginator(scanRequest);
            this.resultSet = new DynamoResultIterable(this, (Iterable<?>)scanResponses, totalRows);
            if (this.offset > 0L) {
                int i = 0;
                while ((long)i < this.offset) {
                    if (!this.resultSet.nextRow()) {
                        break;
                    }
                    ++i;
                }
            }
            return true;
        }
        finally {
            if (((DynamoSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    public DynamoResultIterable openResultSet() throws DBCException {
        return this.resultSet;
    }

    public void setDataFilter(DBDDataFilter dataFilter) {
        this.dataFilter = dataFilter;
    }

    private void addScanConditions(ScanRequest.Builder srBuilder, Map<String, Condition> keyConditions) throws DBException {
        DynamoTableKey tableKey = this.table.getKey(((DynamoSession)this.getSession()).getProgressMonitor());
        boolean hasKeyConditions = true;
        for (DynamoTableKey.KeyAttribute ka : tableKey.getAttributes()) {
            if (keyConditions.containsKey(ka.getName())) continue;
            hasKeyConditions = false;
            break;
        }
        if (!CommonUtils.isEmpty(keyConditions)) {
            StringBuilder scanExpression = new StringBuilder();
            LinkedHashMap<String, CharSequence> exprAttrNames = new LinkedHashMap<String, CharSequence>();
            LinkedHashMap<String, AttributeValue> exprAttrValues = new LinkedHashMap<String, AttributeValue>();
            HashSet<String> filterAttributes = new HashSet<String>();
            for (Map.Entry<String, Condition> ce : keyConditions.entrySet()) {
                String keyName = ce.getKey();
                if (hasKeyConditions && tableKey.containsAttribute(keyName) && ce.getValue().comparisonOperator() == ComparisonOperator.EQ && ce.getValue().attributeValueList() != null && ce.getValue().attributeValueList().size() == 1) continue;
                CharSequence[] keyNames = SQLUtils.splitFullIdentifier((String)keyName, (String)".", (String[][])SQLConstants.DOUBLE_QUOTE_STRINGS, (boolean)false);
                String refKeyName = "#" + String.join((CharSequence)".#", keyNames);
                String refKeyValue = ":" + CommonUtils.escapeIdentifier((String)keyName);
                Condition keyValue = ce.getValue();
                CharSequence[] charSequenceArray = keyNames;
                int n = keyNames.length;
                int n2 = 0;
                while (n2 < n) {
                    CharSequence keyNamePart = charSequenceArray[n2];
                    exprAttrNames.put("#" + (String)keyNamePart, keyNamePart);
                    ++n2;
                }
                exprAttrValues.put(refKeyValue, (AttributeValue)keyValue.attributeValueList().get(0));
                if (scanExpression.length() > 0) {
                    scanExpression.append(" AND ");
                }
                scanExpression.append(refKeyName).append(" ").append(DynamoSQL.getComparisonOperatorExpression(keyValue.comparisonOperator())).append(' ').append(refKeyValue);
                filterAttributes.add(keyName);
            }
            for (String attr : filterAttributes) {
                keyConditions.remove(attr);
            }
            srBuilder.filterExpression(scanExpression.toString());
            if (!exprAttrNames.isEmpty()) {
                srBuilder.expressionAttributeNames(exprAttrNames);
            }
            if (!exprAttrValues.isEmpty()) {
                srBuilder.expressionAttributeValues(exprAttrValues);
            }
        }
        if (!keyConditions.isEmpty()) {
            LinkedHashMap<String, AttributeValue> startKey = new LinkedHashMap<String, AttributeValue>();
            for (Map.Entry<String, Condition> kc : keyConditions.entrySet()) {
                startKey.put(kc.getKey(), (AttributeValue)kc.getValue().attributeValueList().get(0));
            }
            srBuilder.exclusiveStartKey(startKey);
        }
    }
}

