/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.ee.model.document.data.DBAbstractDocument;
import com.dbeaver.ee.model.document.data.DBMapValue;
import java.util.Arrays;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;

public class DynamoPutStatement
extends DynamoBaseStatement {
    private DynamoTable table;
    private DBSAttributeBase[] valueAttributes;
    private Object[] rowValues;

    public DynamoPutStatement(DynamoSession session, DBCExecutionSource source, DynamoTable table, DBSAttributeBase[] updateAttributes, Object[] rowValues) {
        super(session, source);
        this.table = table;
        this.valueAttributes = updateAttributes;
        this.rowValues = rowValues;
    }

    public void setRowValues(Object[] rowValues) {
        this.rowValues = rowValues;
    }

    @Nullable
    public String getQueryString() {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(this.table.getName());
        DBMapValue rootNode = ((DBAbstractDocument)this.rowValues[0]).getRootNode();
        for (Map.Entry ae : rootNode.getRawValue().entrySet()) {
            sql.append("\nADD ");
            sql.append((String)ae.getKey()).append(" = '").append(ae.getValue()).append("'");
        }
        return sql.toString();
    }

    public boolean executeStatement() throws DBCException {
        try {
            if (this.valueAttributes.length != 1 || this.valueAttributes[0].getDataKind() != DBPDataKind.DOCUMENT) {
                throw new DBCException("Unsupported document value: " + Arrays.toString(this.valueAttributes));
            }
            Map<String, AttributeValue> o = DynamoDBUtils.makeDynamoDocument((DBMapValue<DynamoDataSource>)((DBAbstractDocument)this.rowValues[0]).getRootNode());
            PutItemRequest pir = (PutItemRequest)PutItemRequest.builder().tableName(this.table.getName()).item(o).build();
            ((DynamoSession)this.getSession()).getDataSource().getClient().putItem(pir);
            return false;
        }
        catch (Throwable e) {
            throw new DBCException("Error saving document", e);
        }
    }

    @Nullable
    public DBCResultSet openResultSet() throws DBCException {
        return null;
    }

    @Override
    public DynamoTable getSourceEntity() {
        return this.table;
    }
}

