/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import com.dbeaver.db.dynamodb.data.DynamoDocument;
import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import java.util.Arrays;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;

public class DynamoDeleteStatement
extends DynamoBaseStatement {
    private DynamoTable table;
    private DBSAttributeBase[] valueAttributes;
    private Object[] rowValues;

    public DynamoDeleteStatement(DynamoSession session, DBCExecutionSource source, DynamoTable table, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        super(session, source);
        this.table = table;
        this.valueAttributes = keyAttributes;
        this.rowValues = rowValues;
    }

    public void setRowValues(Object[] rowValues) {
        this.rowValues = rowValues;
    }

    @Nullable
    public String getQueryString() {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ").append(this.table.getName()).append(" WHERE ");
        if (this.valueAttributes.length == 1 && this.valueAttributes[0].getDataKind() == DBPDataKind.DOCUMENT) {
            try {
                Map<String, AttributeValue> keyValue = ((DynamoDocument)((Object)this.rowValues[0])).getKeyValues(((DynamoSession)this.getSession()).getProgressMonitor());
                boolean first = true;
                for (Map.Entry<String, AttributeValue> ae : keyValue.entrySet()) {
                    sql.append("\n");
                    if (!first) {
                        sql.append("AND ");
                    }
                    first = false;
                    sql.append(ae.getKey()).append(" = '").append(DynamoDBUtils.getRawAttributeValue((DynamoDataSource)this.table.getDataSource(), null, ae.getValue())).append("'");
                }
            }
            catch (DBException e) {
                sql.append(e.getMessage());
            }
        } else {
            sql.append("??? -- Unsupported key type");
        }
        return sql.toString();
    }

    public boolean executeStatement() throws DBCException {
        try {
            if (this.valueAttributes.length != 1 || this.valueAttributes[0].getDataKind() != DBPDataKind.DOCUMENT) {
                throw new DBCException("Unsupported item value: " + Arrays.toString(this.valueAttributes));
            }
            Map<String, AttributeValue> keyValue = ((DynamoDocument)((Object)this.rowValues[0])).getKeyValues(((DynamoSession)this.getSession()).getProgressMonitor());
            DeleteItemRequest dir = (DeleteItemRequest)DeleteItemRequest.builder().tableName(this.table.getName()).key(keyValue).build();
            ((DynamoSession)this.getSession()).getDataSource().getClient().deleteItem(dir);
            return false;
        }
        catch (Throwable e) {
            throw new DBCException("Error deleting item", e);
        }
    }

    @Nullable
    public DBCResultSet openResultSet() throws DBCException {
        return null;
    }

    @Override
    public DynamoTable getSourceEntity() {
        return this.table;
    }
}

