/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.ee.model.document.exec.DocumentReadStatement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class DynamoBaseStatement
extends DocumentReadStatement<DynamoSession> {
    protected long offset;
    protected long limit;

    protected DynamoBaseStatement(DynamoSession session, DBCExecutionSource source) {
        super((DBCSession)session);
        this.setStatementSource(source);
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    protected DynamoBaseStatement(DynamoSession session) {
        this(session, null);
    }

    public abstract DynamoTable getSourceEntity();

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCException("Not implemented");
    }

    public int getUpdateRowCount() {
        return -1;
    }

    public void addToBatch() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public boolean nextResults() throws DBCException {
        return false;
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = offset;
        this.limit = limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public void close() {
        if (((DynamoSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, (long)this.getUpdateRowCount());
        }
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread == null) {
            throw new DBException("DynamoDB query cancel not implemented");
        }
        blockThread.interrupt();
    }
}

