/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.data;

import com.dbeaver.db.dynamodb.DynamoDBUtils;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import com.dbeaver.db.dynamodb.model.DynamoTableKey;
import com.dbeaver.ee.model.document.data.DBAbstractDocument;
import com.dbeaver.ee.model.document.data.DBMapValue;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class DynamoDocument
extends DBAbstractDocument<DynamoDataSource, Map<String, AttributeValue>> {
    private static final Log log = Log.getLog(DynamoDocument.class);
    @Nullable
    private DynamoTable table;

    public DynamoDocument(@NotNull DynamoDataSource dataSource, @Nullable DynamoTable table, Map<String, AttributeValue> item) {
        super((DBPDataSource)dataSource, item);
        this.table = table;
    }

    @Nullable
    public DynamoTable getTable() {
        return this.table;
    }

    public Map<String, AttributeValue> getKeyValues(DBRProgressMonitor monitor) throws DBException {
        if (this.table == null) {
            throw new DBCException("Document doesn't belong to a table");
        }
        DynamoTableKey key = this.table.getKey(monitor);
        LinkedHashMap<String, AttributeValue> keyValues = new LinkedHashMap<String, AttributeValue>();
        for (DynamoTableKey.KeyAttribute ka : key.getAttributes()) {
            keyValues.put(ka.getName(), (AttributeValue)((Map)this.rawValue).get(ka.getName()));
        }
        return keyValues;
    }

    public Map<String, AttributeValue> getNonKeyValues(DBRProgressMonitor monitor) throws DBException {
        if (this.table == null) {
            throw new DBCException("Document doesn't belong to a table");
        }
        DynamoTableKey key = this.table.getKey(monitor);
        LinkedHashMap<String, AttributeValue> values = new LinkedHashMap<String, AttributeValue>();
        for (Map.Entry ae : ((Map)this.getRawValue()).entrySet()) {
            if (key.containsAttribute((String)ae.getKey())) continue;
            values.put((String)ae.getKey(), (AttributeValue)ae.getValue());
        }
        return values;
    }

    @Nullable
    public Object getDocumentId() {
        DynamoTableKey key;
        block5: {
            DynamoTableKey dynamoTableKey = key = this.table == null ? null : this.table.getKey((DBRProgressMonitor)new VoidProgressMonitor());
            if (key != null) break block5;
            return null;
        }
        try {
            StringBuilder idStr = new StringBuilder();
            for (DynamoTableKey.KeyAttribute attr : key.getAttributes()) {
                Object rawValue = this.getRootNode().getAttributeValue(attr.getName());
                if (idStr.length() > 0) {
                    idStr.append(", ");
                }
                idStr.append(attr.getName()).append(":").append(rawValue);
            }
            return idStr.toString();
        }
        catch (DBException e) {
            log.error((Object)e);
            return null;
        }
    }

    public Object getDocumentProperty(String name) {
        switch (name) {
            case "id": {
                return this.getDocumentId();
            }
        }
        return null;
    }

    @NotNull
    public String getDocumentContentType() {
        return "text/json";
    }

    protected DBMapValue<DynamoDataSource> makeRawMap() {
        return DynamoDBUtils.makeDocumentMap((DynamoDataSource)this.dataSource, this, (Map)this.rawValue);
    }

    public void serializeDocument(@NotNull DBRProgressMonitor monitor, @NotNull OutputStream stream, Charset charset) throws DBException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStreamWriter out = new OutputStreamWriter(stream, charset);){
            ((DynamoDataSource)this.dataSource).serializeDocument(DynamoDBUtils.makeDynamoDocument((DBMapValue<DynamoDataSource>)this.getRootNode()), (Writer)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void updateDocument(@NotNull DBRProgressMonitor monitor, @NotNull InputStream stream, Charset charset) throws DBException, IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader reader = new InputStreamReader(stream);){
            this.rawMap = new DBMapValue((DBPDataSource)((DynamoDataSource)this.dataSource), (Object)this, ((DynamoDataSource)this.dataSource).deserializeDocument(reader));
            this.rawValue = DynamoDBUtils.makeDynamoDocument((DBMapValue<DynamoDataSource>)this.rawMap);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.markModified();
    }

    public DynamoDocument copy() {
        return new DynamoDocument((DynamoDataSource)this.dataSource, this.table, this.rawValue == null ? null : new LinkedHashMap((Map)this.rawValue));
    }

    public static class AttributeValueConverter
    implements JsonSerializer<AttributeValue>,
    JsonDeserializer<AttributeValue> {
        public JsonElement serialize(AttributeValue src, Type srcType, JsonSerializationContext context) {
            return DynamoDBUtils.getJsonAttributeValue(src);
        }

        public AttributeValue deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return (AttributeValue)AttributeValue.builder().n(json.getAsString()).build();
        }
    }
}

