/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.importer;

import com.monitorjbl.xlsx.StreamingReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.local.LocalStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataImporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.StreamEntityMapping;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferResultSet;
import org.jkiss.dbeaver.tools.transfer.stream.importer.StreamImporterAbstract;
import org.jkiss.utils.CommonUtils;

public class DataImporterXLSX
extends StreamImporterAbstract {
    private static final Log log = Log.getLog(DataImporterXLSX.class);
    private static final String PROP_HEADER = "header";
    private static final String PROP_SKIP_EMPTY_ROWS = "skipEmptyRows";
    private static final String PROP_MANY_SHEETS = "manySheets";
    private static final int MAX_COLUMN_LENGTH = 1024;

    @NotNull
    public List<StreamDataImporterColumnInfo> readColumnsInfo(StreamEntityMapping entityMapping, @NotNull InputStream inputStream) throws DBException {
        ArrayList<StreamDataImporterColumnInfo> columnsInfo = new ArrayList<StreamDataImporterColumnInfo>();
        Map processorProperties = this.getSite().getProcessorProperties();
        HeaderPosition headerPosition = this.getHeaderPosition(processorProperties);
        boolean useManySheets = CommonUtils.getBoolean(processorProperties.get(PROP_MANY_SHEETS), (boolean)false);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (Workbook workbook = StreamingReader.builder().rowCacheSize(200).bufferSize(10000).open(inputStream);){
                for (Sheet sheet : workbook) {
                    Iterator rowIterator = sheet.rowIterator();
                    if (rowIterator.hasNext()) {
                        Row row = (Row)rowIterator.next();
                        boolean hasNext = rowIterator.hasNext();
                        Row nextRow = null;
                        if (hasNext) {
                            nextRow = (Row)rowIterator.next();
                        }
                        int i = 0;
                        while (i < row.getLastCellNum()) {
                            String typeName;
                            CellType cellTypeEnum;
                            String columnName = "Column" + i;
                            boolean isADate = false;
                            if (headerPosition != HeaderPosition.none) {
                                columnName = row.getCell(i).getStringCellValue();
                            }
                            Cell cell = row.getCell(i);
                            DBPDataKind dataKind = DBPDataKind.STRING;
                            if (headerPosition != HeaderPosition.none && hasNext && nextRow != null) {
                                Cell nextRowCell = nextRow.getCell(i);
                                cellTypeEnum = nextRowCell.getCellType();
                                if (cellTypeEnum == CellType.NUMERIC) {
                                    isADate = DateUtil.isCellDateFormatted((Cell)nextRowCell);
                                }
                            } else {
                                cellTypeEnum = cell.getCellType();
                            }
                            switch (cellTypeEnum) {
                                case STRING: 
                                case BLANK: {
                                    typeName = "VARCHAR";
                                    break;
                                }
                                case NUMERIC: {
                                    if (isADate) {
                                        dataKind = DBPDataKind.DATETIME;
                                        typeName = "DATE";
                                        break;
                                    }
                                    dataKind = DBPDataKind.NUMERIC;
                                    typeName = "INT";
                                    break;
                                }
                                case BOOLEAN: {
                                    dataKind = DBPDataKind.BOOLEAN;
                                    typeName = "BOOLEAN";
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("Unexpected value: " + cell.getCellType());
                                }
                            }
                            columnsInfo.add(new StreamDataImporterColumnInfo(entityMapping, i, columnName, typeName, 1024, dataKind));
                            ++i;
                        }
                    } else {
                        throw new DBException("Empty XLSX file");
                    }
                    if (useManySheets) continue;
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw new DBException("Error reading XLSX", e);
        }
        return columnsInfo;
    }

    public void runImport(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource streamDataSource, @NotNull InputStream inputStream, @NotNull IDataTransferConsumer consumer) throws DBException {
        IStreamDataImporterSite site = this.getSite();
        StreamEntityMapping entityMapping = site.getSourceObject();
        Map properties = site.getProcessorProperties();
        boolean skipEmptyRow = CommonUtils.getBoolean(properties.get(PROP_SKIP_EMPTY_ROWS), (boolean)true);
        boolean useManySheets = CommonUtils.getBoolean(properties.get(PROP_MANY_SHEETS), (boolean)false);
        DBCExecutionContext context = streamDataSource.getDefaultInstance().getDefaultContext(monitor, false);
        Throwable throwable = null;
        Object var12_13 = null;
        try (DBCSession producerSession = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Transfer stream data");){
            LocalStatement localStatement = new LocalStatement(producerSession, "SELECT * FROM Stream");
            StreamTransferResultSet resultSet = new StreamTransferResultSet(producerSession, (DBCStatement)localStatement, entityMapping);
            consumer.fetchStart(producerSession, (DBCResultSet)resultSet, -1L, -1L);
            this.applyTransformHints(resultSet, consumer, properties, "timestampFormat", "timestampZone");
            try {
                try {
                    Throwable throwable2 = null;
                    Object var17_21 = null;
                    try (Workbook workbook = StreamingReader.builder().rowCacheSize(200).bufferSize(10000).open(inputStream);){
                        for (Sheet sheet : workbook) {
                            HeaderPosition headerPosition = this.getHeaderPosition(properties);
                            int maxRows = site.getSettings().getMaxRows();
                            int targetAttrSize = entityMapping.getStreamColumns().size();
                            boolean headerRead = false;
                            monitor.subTask("Import from XLSX file");
                            int rowNum = 0;
                            Iterator iterator = sheet.iterator();
                            while (iterator.hasNext()) {
                                Row row = (Row)iterator.next();
                                if (monitor.isCanceled()) break;
                                ++rowNum;
                                if (headerPosition != HeaderPosition.none && !headerRead) {
                                    headerRead = true;
                                    continue;
                                }
                                if (headerPosition == HeaderPosition.both && !iterator.hasNext() || maxRows > 0 && rowNum >= maxRows) break;
                                Object[] cellsToResultSet = new Object[row.getLastCellNum()];
                                boolean allBlank = true;
                                int cellNum = row.getFirstCellNum();
                                while (cellNum < row.getLastCellNum()) {
                                    Cell currentCell = row.getCell(cellNum);
                                    if (currentCell.getCellType() != CellType.BLANK) {
                                        allBlank = false;
                                    }
                                    switch (currentCell.getCellType()) {
                                        case NUMERIC: {
                                            if (DateUtil.isCellDateFormatted((Cell)currentCell)) {
                                                cellsToResultSet[cellNum] = currentCell.getDateCellValue();
                                                break;
                                            }
                                            cellsToResultSet[cellNum] = currentCell.getNumericCellValue();
                                            break;
                                        }
                                        case STRING: {
                                            cellsToResultSet[cellNum] = currentCell.getStringCellValue();
                                            break;
                                        }
                                        case BOOLEAN: {
                                            cellsToResultSet[cellNum] = currentCell.getBooleanCellValue();
                                            break;
                                        }
                                        case BLANK: {
                                            cellsToResultSet[cellNum] = null;
                                            break;
                                        }
                                        default: {
                                            cellsToResultSet[cellNum] = currentCell.getStringCellValue();
                                        }
                                    }
                                    ++cellNum;
                                }
                                if (skipEmptyRow && allBlank) continue;
                                if (cellsToResultSet.length < targetAttrSize) {
                                    Object[] newCellsToResultSet = new Object[targetAttrSize];
                                    System.arraycopy(cellsToResultSet, 0, newCellsToResultSet, 0, cellsToResultSet.length);
                                    int i = cellsToResultSet.length;
                                    while (i < targetAttrSize) {
                                        cellsToResultSet[i] = null;
                                        ++i;
                                    }
                                    cellsToResultSet = newCellsToResultSet;
                                }
                                resultSet.setStreamRow(cellsToResultSet);
                                consumer.fetchRow(producerSession, (DBCResultSet)resultSet);
                                monitor.worked(1);
                                if (rowNum % 1000 != 0) continue;
                                monitor.subTask(String.valueOf(String.valueOf(rowNum)) + " rows processed");
                            }
                            if (useManySheets) continue;
                            break;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    throw new DBException("IO error reading XLSX", (Throwable)e);
                }
            }
            finally {
                try {
                    consumer.fetchEnd(producerSession, (DBCResultSet)resultSet);
                }
                finally {
                    consumer.close();
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private HeaderPosition getHeaderPosition(Map<String, Object> processorProperties) {
        return (HeaderPosition)CommonUtils.valueOf(HeaderPosition.class, (String)CommonUtils.toString((Object)processorProperties.get(PROP_HEADER)), (Enum)HeaderPosition.none);
    }

    static enum HeaderPosition {
        none,
        top,
        both;

    }
}

