/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.snapshot;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.ext.vertica.snapshot.VerticaResultSetConstraintsExtractor;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.jvm.UniqueConstraintSnapshotGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;

public class UniqueConstraintSnapshotGeneratorVertica
extends UniqueConstraintSnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof VerticaDatabase) {
            return 5;
        }
        return -1;
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{UniqueConstraintSnapshotGenerator.class};
    }

    protected List<CachedRow> listConstraints(Table table, DatabaseSnapshot snapshot, Schema schema) throws DatabaseException, SQLException {
        return new VerticaResultSetConstraintsExtractor(snapshot, schema.getCatalogName(), schema.getName(), table.getName()).fastFetch();
    }

    protected List<Map<String, ?>> listColumns(UniqueConstraint example, Database database, DatabaseSnapshot snapshot) throws DatabaseException {
        Relation table = example.getRelation();
        Schema schema = table.getSchema();
        String name = example.getName();
        String schemaName = database.correctObjectName(schema.getName(), Schema.class);
        String constraintName = database.correctObjectName(name, UniqueConstraint.class);
        String tableName = database.correctObjectName(table.getName(), Table.class);
        String sql = "SELECT CONSTRAINT_NAME, COLUMN_NAME FROM v_catalog.constraint_columns cc WHERE constraint_type='u'";
        if (schemaName != null) {
            sql = sql + "and table_schema='" + schemaName + "' ";
        }
        if (tableName != null) {
            sql = sql + "and table_name='" + tableName + "' ";
        }
        if (constraintName != null) {
            sql = sql + "and CONSTRAINT_NAME='" + constraintName + "'";
        }
        List rows = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)new RawSqlStatement(sql));
        return rows;
    }
}

