/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.change;

import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.DropTableChange;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.ext.vertica.change.ColumnConfigVertica;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.ext.vertica.statement.CreateTempTableStatementVertica;
import liquibase.ext.vertica.structure.Segmentation;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ColumnConstraint;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.NotNullConstraint;
import liquibase.statement.SqlStatement;
import liquibase.statement.UniqueConstraint;
import liquibase.statement.core.SetColumnRemarksStatement;
import liquibase.statement.core.SetTableRemarksStatement;
import liquibase.util.StringUtil;

@DatabaseChange(name="createTempTable", description="create temporary tables", priority=5)
public class CreateTempTableChangeVertica
extends AbstractChange
implements ChangeWithColumns<ColumnConfig> {
    private String schemaName;
    private String tablespace;
    private String remarks;
    private String tableName;
    private Boolean isGlobal;
    private Boolean isPreserve;
    private String projectionName;
    private String viewName;
    private String columnAliases;
    private String objectType;
    private Boolean reducedPrecision;
    private Boolean usingIndex;
    private String tableSpace;
    private Boolean forUpdate;
    private String orderby;
    private String partitionby;
    private Integer ksafe;
    private Segmentation segmentation;
    private String subquery;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    @DatabaseChangeProperty(requiredForDatabase={"vertica"})
    public List<ColumnConfig> getColumns() {
        if (this.columns == null) {
            return new ArrayList<ColumnConfig>();
        }
        return this.columns;
    }

    public void setColumns(List<ColumnConfig> columns) {
        this.columns = columns;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.addAll(super.validate(database));
        if (this.columns != null) {
            for (ColumnConfig columnConfig : this.columns) {
                if (columnConfig.getType() == null) {
                    validationErrors.addError("column 'type' is required for all columns");
                }
                if (columnConfig.getName() != null) continue;
                validationErrors.addError("column 'name' is required for all columns");
            }
        }
        return validationErrors;
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateTempTableStatementVertica statement = new CreateTempTableStatementVertica("", this.getSchemaName(), this.getTableName());
        for (ColumnConfig column : this.getColumns()) {
            ColumnConfigVertica col;
            ConstraintsConfig constraints = column.getConstraints();
            boolean isAutoIncrement = column.isAutoIncrement() != null && column.isAutoIncrement() != false;
            Object defaultValue = column.getDefaultValueObject();
            LiquibaseDataType columnType = DataTypeFactory.getInstance().fromDescription(column.getType() + (isAutoIncrement ? "{autoIncrement:true}" : ""), database);
            if (constraints != null && constraints.isPrimaryKey() != null && constraints.isPrimaryKey().booleanValue()) {
                if (column instanceof ColumnConfigVertica) {
                    col = (ColumnConfigVertica)column;
                    statement.addPrimaryKeyColumn(column.getName(), columnType, defaultValue, constraints.getPrimaryKeyName(), col.getEncoding(), col.getAccessrank(), constraints.getPrimaryKeyTablespace(), new ColumnConstraint[0]);
                } else {
                    statement.addPrimaryKeyColumn(column.getName(), columnType, defaultValue, constraints.getPrimaryKeyName(), null, null, constraints.getPrimaryKeyTablespace(), new ColumnConstraint[0]);
                }
            } else if (column instanceof ColumnConfigVertica) {
                col = (ColumnConfigVertica)column;
                statement.addColumn(column.getName(), columnType, defaultValue, col.getEncoding(), col.getAccessrank(), null, new ColumnConstraint[0]);
            } else {
                statement.addColumn(column.getName(), columnType, defaultValue, column.getEncoding(), (String)null, null);
            }
            if (constraints != null) {
                if (constraints.isNullable() != null && !constraints.isNullable().booleanValue()) {
                    statement.addColumnConstraint(new NotNullConstraint(column.getName()));
                }
                if (constraints.getReferences() != null || constraints.getReferencedTableName() != null && constraints.getReferencedColumnNames() != null) {
                    if (StringUtil.trimToNull((String)constraints.getForeignKeyName()) == null) {
                        throw new UnexpectedLiquibaseException("createTable with references requires foreignKeyName");
                    }
                    ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint(constraints.getForeignKeyName(), constraints.getReferences(), constraints.getReferencedTableName(), constraints.getReferencedColumnNames());
                    fkConstraint.setColumn(column.getName());
                    fkConstraint.setDeleteCascade(constraints.isDeleteCascade() != null && constraints.isDeleteCascade() != false);
                    fkConstraint.setInitiallyDeferred(constraints.isInitiallyDeferred() != null && constraints.isInitiallyDeferred() != false);
                    fkConstraint.setDeferrable(constraints.isDeferrable() != null && constraints.isDeferrable() != false);
                    statement.addColumnConstraint(fkConstraint);
                }
                if (constraints.isUnique() != null && constraints.isUnique().booleanValue()) {
                    statement.addColumnConstraint(new UniqueConstraint(constraints.getUniqueConstraintName()).addColumns(new String[]{column.getName()}));
                }
            }
            if (!isAutoIncrement) continue;
            statement.addColumnConstraint(new AutoIncrementConstraint(column.getName(), column.getStartWith(), column.getIncrementBy()));
        }
        statement.setTablespace(StringUtil.trimToNull((String)this.getTablespace()));
        statement.setSegmentation(this.getSegmentation());
        statement.setPartitionby(this.getPartitionby());
        statement.setOrderby(this.getOrderby());
        statement.setKsafe(this.getKsafe());
        statement.setIsGlobal(this.getIsGlobal());
        statement.setIsPreserve(this.getIsPreserve());
        ArrayList<CreateTempTableStatementVertica> statements = new ArrayList<CreateTempTableStatementVertica>();
        statements.add(statement);
        if (StringUtil.trimToNull((String)this.remarks) != null) {
            SetTableRemarksStatement remarksStatement = new SetTableRemarksStatement("", this.schemaName, this.tableName, this.remarks);
            if (SqlGeneratorFactory.getInstance().supports((SqlStatement)remarksStatement, database)) {
                statements.add((CreateTempTableStatementVertica)remarksStatement);
            }
        }
        for (ColumnConfig column : this.getColumns()) {
            String columnRemarks = StringUtil.trimToNull((String)column.getRemarks());
            if (columnRemarks == null) continue;
            SetColumnRemarksStatement remarksStatement = new SetColumnRemarksStatement("", this.schemaName, this.tableName, column.getName(), columnRemarks);
            if (!SqlGeneratorFactory.getInstance().supports((SqlStatement)remarksStatement, database)) continue;
            statements.add((CreateTempTableStatementVertica)remarksStatement);
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    protected Change[] createInverses() {
        DropTableChange inverse = new DropTableChange();
        inverse.setCatalogName("");
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        return new Change[]{inverse};
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getConfirmationMessage() {
        return "Table " + this.tableName + " created";
    }

    public boolean supports(Database database) {
        return database instanceof VerticaDatabase;
    }

    public ColumnConfigVertica createColumnv() {
        ColumnConfigVertica col = new ColumnConfigVertica();
        this.columns.add((ColumnConfig)col);
        return col;
    }

    public Segmentation createSegmentation() {
        this.segmentation = new Segmentation();
        return this.segmentation;
    }

    public String getOrderby() {
        return this.orderby;
    }

    public void setOrderby(String orderby) {
        this.orderby = orderby;
    }

    public String getPartitionby() {
        return this.partitionby;
    }

    public void setPartitionby(String partitionby) {
        this.partitionby = partitionby;
    }

    public Integer getKsafe() {
        return this.ksafe;
    }

    public void setKsafe(Integer ksafe) {
        this.ksafe = ksafe;
    }

    public Segmentation getSegmentation() {
        return this.segmentation;
    }

    public String getSubquery() {
        return this.subquery;
    }

    public Boolean getIsGlobal() {
        return this.isGlobal;
    }

    public void setIsGlobal(Boolean isGlobal) {
        this.isGlobal = isGlobal;
    }

    public Boolean getIsPreserve() {
        return this.isPreserve;
    }

    public void setIsPreserve(Boolean isPreserve) {
        this.isPreserve = isPreserve;
    }
}

